/*
 * Decompiled with CFR 0.152.
 */
package com.electron.taigaexpansion;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="taigaexpansion", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfigs {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class CommonConfig {
        public final Balance balance;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.balance = new Balance(builder);
        }

        public static class Balance {
            public static String name = "balance";
            public static ForgeConfigSpec.ConfigValue<Integer> cheerfulness_level;
            public static ForgeConfigSpec.ConfigValue<Boolean> only_vanilla_taiga_features;
            public static ForgeConfigSpec.ConfigValue<Boolean> rotten_logs;
            public static ForgeConfigSpec.ConfigValue<Boolean> lichen;

            public Balance(ForgeConfigSpec.Builder builder) {
                builder.push(name);
                only_vanilla_taiga_features = builder.comment("Structures and Features appears only in vanilla biomes").define("only_vanilla_taiga_features", false);
                lichen = builder.comment("Lichen generation").define("lichen", true);
                rotten_logs = builder.comment("Rotten Logs generation").define("rotten_logs", true);
                cheerfulness_level = builder.comment("Cheerfulness effect amplifier").defineInRange("cheerfulness_level", 3, 0, 20);
                builder.pop();
            }
        }
    }
}

