/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client;

import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.client.LoadingWorldGetter;
import net.gegy1000.earth.client.gui.EarthLocateGui;
import net.gegy1000.earth.client.gui.EarthPreloadGui;
import net.gegy1000.earth.client.gui.EarthPreloadProgressGui;
import net.gegy1000.earth.client.render.LoadingScreenOverlay;
import net.gegy1000.earth.client.render.PanoramaHandler;
import net.gegy1000.earth.server.ServerProxy;
import net.gegy1000.earth.server.capability.EarthWorld;
import net.gegy1000.earth.server.message.EarthOpenMapMessage;
import net.gegy1000.earth.server.world.data.GooglePanorama;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends ServerProxy {
    @Override
    public void onPostInit() {
        LoadingScreenOverlay.onPostInit();
        LoadingWorldGetter.onPostInit();
    }

    @Override
    public void openDownload(long count, long total) {
        Minecraft client = Minecraft.func_71410_x();
        if (client.field_71462_r == null) {
            client.func_147108_a((GuiScreen)new EarthPreloadProgressGui(count, total));
        }
    }

    @Override
    public void updateDownload(long count) {
        Minecraft client = Minecraft.func_71410_x();
        if (client.field_71462_r instanceof EarthPreloadProgressGui) {
            ((EarthPreloadProgressGui)client.field_71462_r).update(count);
        }
    }

    @Override
    public void openMapGui(EarthOpenMapMessage.Type type, double latitude, double longitude) {
        Minecraft client = Minecraft.func_71410_x();
        switch (type) {
            case LOCATE: {
                client.func_147108_a((GuiScreen)new EarthLocateGui(latitude, longitude));
                break;
            }
            case PRELOAD: {
                EarthWorld earth = EarthWorld.get((World)client.field_71441_e);
                if (earth == null) break;
                client.func_147108_a((GuiScreen)new EarthPreloadGui(earth, latitude, longitude));
            }
        }
    }

    @Override
    public void displayPanorama() {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EarthWorld earth = (EarthWorld)world.getCapability(TerrariumEarth.worldCap(), null);
        if (earth != null) {
            EntityPlayerSP player = mc.field_71439_g;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("status.earth.panorama.searching", new Object[0]), true);
            Coordinate coordinate = Coordinate.atBlock(player.field_70165_t, player.field_70161_v).to(earth.getCrs());
            double longitude = coordinate.getX();
            double latitude = coordinate.getZ();
            Thread thread = new Thread(() -> this.lambda$displayPanorama$1(latitude, longitude, earth, (EntityPlayer)player));
            thread.setDaemon(true);
            thread.setName("Panorama Lookup");
            thread.start();
        }
    }

    private void setPanoramaState(EarthWorld earth, EntityPlayer player, GooglePanorama panorama) {
        double blockZ;
        double deltaZ;
        Coordinate coord = earth.getCrs().coord(panorama.getLongitude(), panorama.getLatitude());
        double blockX = coord.getBlockX();
        double deltaX = player.field_70165_t - blockX;
        if (deltaX * deltaX + (deltaZ = player.field_70161_v - (blockZ = coord.getBlockZ())) * deltaZ < 2.25) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("status.earth.panorama.immersed", new Object[0]), true);
            PanoramaHandler.setState(new PanoramaHandler.Immersed(panorama, blockX, player.field_70163_u, blockZ));
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("status.earth.panorama.found", new Object[0]), true);
            PanoramaHandler.setState(new PanoramaHandler.Located(panorama, blockX, blockZ));
        }
    }

    private /* synthetic */ void lambda$displayPanorama$1(double latitude, double longitude, EarthWorld earth, EntityPlayer player) {
        try {
            GooglePanorama result = GooglePanorama.lookup(latitude, longitude, 150.0);
            if (result != null) {
                Minecraft.func_71410_x().func_152344_a(() -> this.setPanoramaState(earth, player, result));
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("status.earth.panorama.none_found", new Object[0]), true);
            }
        }
        catch (Exception e) {
            TerrariumEarth.LOGGER.error("Failed to lookup panorama", (Throwable)e);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("status.earth.panorama.error", new Object[0]), true);
        }
    }
}

