/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client;

import java.util.List;
import net.gegy1000.earth.client.gui.RemoteDataWarningGui;
import net.gegy1000.earth.client.gui.SharedInitializingGui;
import net.gegy1000.earth.server.config.TerrariumEarthConfig;
import net.gegy1000.earth.server.shared.SharedEarthData;
import net.gegy1000.gengen.api.GenericWorldType;
import net.gegy1000.terrarium.client.ClientProxy;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiListWorldSelection;
import net.minecraft.client.gui.GuiListWorldSelectionEntry;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="earth", value={Side.CLIENT})
public final class PrepareTerrarium {
    public static GuiScreen prepareScreen(GuiScreen returnTo, Runnable onReturn) {
        GuiScreen screen = new SharedInitializingGui(returnTo, onReturn);
        if (!TerrariumEarthConfig.acceptedRemoteDataWarning) {
            screen = new RemoteDataWarningGui(screen);
        }
        return screen;
    }

    @SubscribeEvent
    public static void onButtonPress(GuiScreenEvent.ActionPerformedEvent event) {
        int selectedWorldIndex;
        TerrariumWorldType worldType;
        if (SharedEarthData.isInitialized()) {
            return;
        }
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiCreateWorld && event.getButton().field_146127_k == 0 && (worldType = GenericWorldType.unwrapAs(WorldType.field_77139_a[selectedWorldIndex = ClientProxy.getSelectedWorldType((GuiCreateWorld)gui)], TerrariumWorldType.class)) != null) {
            PrepareTerrarium.onCreateWorldPressed(event.getButton(), gui);
            event.setCanceled(true);
        }
    }

    private static void onCreateWorldPressed(GuiButton button, GuiScreen gui) {
        gui.field_146297_k.func_147108_a((GuiScreen)new SharedInitializingGui(gui, () -> {
            gui.field_146297_k.func_147108_a(gui);
            ClientProxy.actionPerformed(gui, button);
        }));
    }

    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (SharedEarthData.isInitialized()) {
            return;
        }
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiWorldSelection) {
            GuiListWorldSelection list = ((GuiWorldSelection)gui).field_184866_u;
            List entries = list.field_186799_w;
            for (int i = 0; i < entries.size(); ++i) {
                GuiListWorldSelectionEntry entry = (GuiListWorldSelectionEntry)entries.get(i);
                entries.set(i, new HookedWorldSelectionEntry(list, entry));
            }
        }
    }

    private static class HookedWorldSelectionEntry
    extends GuiListWorldSelectionEntry {
        private static final Minecraft CLIENT = Minecraft.func_71410_x();
        private static final ISaveFormat SAVE_FORMAT = CLIENT.func_71359_d();

        HookedWorldSelectionEntry(GuiListWorldSelection list, GuiListWorldSelectionEntry entry) {
            super(list, entry.field_186786_g, SAVE_FORMAT);
        }

        public void func_186774_a() {
            TerrariumWorldType worldType;
            WorldInfo worldInfo;
            if (!SharedEarthData.isInitialized() && (worldInfo = SAVE_FORMAT.func_75803_c(this.field_186786_g.func_75786_a())) != null && (worldType = GenericWorldType.unwrapAs(worldInfo.func_76067_t(), TerrariumWorldType.class)) != null) {
                CLIENT.func_147108_a(PrepareTerrarium.prepareScreen(HookedWorldSelectionEntry.CLIENT.field_71462_r, () -> super.func_186774_a()));
                return;
            }
            super.func_186774_a();
        }
    }
}

