/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui;

import java.io.IOException;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.client.gui.EarthCustomizationGui;
import net.gegy1000.earth.client.gui.widget.map.PlaceSearchWidget;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapPoint;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapWidget;
import net.gegy1000.earth.client.gui.widget.map.component.MarkerMapComponent;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class SelectEarthSpawnpointGui
extends GuiScreen {
    private static final int SELECT_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int SEARCH_FIELD = 2;
    private final EarthCustomizationGui parent;
    private SlippyMapWidget mapWidget;
    private MarkerMapComponent markerComponent;
    private PlaceSearchWidget searchWidget;

    public SelectEarthSpawnpointGui(EarthCustomizationGui parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        if (this.mapWidget != null) {
            this.mapWidget.close();
        }
        Keyboard.enableRepeatEvents((boolean)true);
        this.mapWidget = new SlippyMapWidget(20, 20, this.field_146294_l - 40, this.field_146295_m - 60);
        GenerationSettings settings = this.parent.getSettings();
        double latitude = settings.getDouble(EarthProperties.SPAWN_LATITUDE);
        double longitude = settings.getDouble(EarthProperties.SPAWN_LONGITUDE);
        this.markerComponent = new MarkerMapComponent(new SlippyMapPoint(latitude, longitude)).allowMovement();
        this.mapWidget.addComponent(this.markerComponent);
        this.searchWidget = new PlaceSearchWidget(2, 25, 25, 200, 20, TerrariumEarth.getPreferredGeocoder(), this::handleSearch);
        this.searchWidget.func_146195_b(true);
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 154, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 4, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
    }

    private void handleSearch(double latitude, double longitude) {
        this.markerComponent.moveMarker(latitude, longitude);
        this.mapWidget.getMap().focus(latitude, longitude, 12);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            SlippyMapPoint marker;
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
            if (button.field_146127_k == 0 && (marker = this.markerComponent.getMarker()) != null) {
                this.parent.applySpawnpoint(marker.getLatitude(), marker.getLongitude());
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        this.mapWidget.draw(mouseX, mouseY, partialTicks);
        this.searchWidget.draw(mouseX, mouseY);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.earth.spawnpoint", (Object[])new Object[0]), this.field_146294_l / 2, 4, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchWidget.update();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchWidget.func_146206_l() && this.searchWidget.func_146201_a(typedChar, keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.searchWidget.func_146192_a(mouseX, mouseY, mouseButton)) {
            return;
        }
        this.mapWidget.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        this.mapWidget.mouseDragged(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        this.mapWidget.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.mapWidget.close();
        this.searchWidget.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

