/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.preview;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.gegy1000.earth.client.terrain.TerrainMesh;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.EarthInitContext;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.justnow.future.Future;
import net.gegy1000.terrarium.server.world.TerrariumDataInitializer;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.gegy1000.terrarium.server.world.data.ColumnData;
import net.gegy1000.terrarium.server.world.data.DataGenerator;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WorldPreview {
    private static final int VIEW_RANGE = 256;
    private static final int VIEW_SIZE = 513;
    private static final int VIEW_GRANULARITY = 2;
    private static final BufferBuilder BUILDER = new BufferBuilder(TerrainMesh.computeBufferSize(513, 513, 2));
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("terrarium-preview-build").build());
    private final TerrainMesh mesh;
    private final Vec3d translation;

    private WorldPreview(TerrainMesh mesh, Vec3d translation) {
        this.mesh = mesh;
        this.translation = translation;
    }

    public static Future<WorldPreview> generate(TerrariumWorldType worldType, GenerationSettings settings) {
        TerrariumDataInitializer dataInitializer = worldType.createDataInitializer(settings);
        EarthInitContext ctx = EarthInitContext.from(settings);
        DataGenerator.Builder dataGenerator = DataGenerator.builder();
        dataInitializer.setup(dataGenerator);
        double latitude = settings.getDouble(EarthProperties.SPAWN_LATITUDE);
        double longitude = settings.getDouble(EarthProperties.SPAWN_LONGITUDE);
        Coordinate spawnCoordinate = ctx.lngLatCrs.coord(longitude, latitude);
        BlockPos topLeft = ctx.lngLatCrs.coord(-180.0, 90.0).toBlockPos().func_177971_a((Vec3i)new BlockPos(4, 0, 4));
        BlockPos bottomRight = ctx.lngLatCrs.coord(180.0, -90.0).toBlockPos().func_177973_b((Vec3i)new BlockPos(4, 0, 4));
        return WorldPreview.generate(dataGenerator.build(), spawnCoordinate.toBlockPos(), topLeft, bottomRight);
    }

    private static Future<WorldPreview> generate(DataGenerator dataGenerator, BlockPos spawnPos, BlockPos minCorner, BlockPos maxCorner) {
        int minX = Math.max(spawnPos.func_177958_n() - 256, minCorner.func_177958_n());
        int minZ = Math.max(spawnPos.func_177952_p() - 256, minCorner.func_177952_p());
        int maxX = Math.min(spawnPos.func_177958_n() + 256, maxCorner.func_177958_n());
        int maxZ = Math.min(spawnPos.func_177952_p() + 256, maxCorner.func_177952_p());
        int width = maxX - minX + 1;
        int height = maxZ - minZ + 1;
        return WorldPreview.sampleData(dataGenerator, minX, minZ, width, height).andThen(data -> Future.spawnBlocking(EXECUTOR, () -> {
            ShortRaster heightRaster = data.getOrDefault(EarthData.TERRAIN_HEIGHT);
            Vec3d translation = new Vec3d((double)(-heightRaster.getWidth()) / 2.0, (double)(-WorldPreview.computeOriginHeight(heightRaster)), (double)(-heightRaster.getHeight()) / 2.0);
            try {
                BUILDER.func_178977_d();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            TerrainMesh mesh = TerrainMesh.build(data, BUILDER, 2);
            return new WorldPreview(mesh, translation);
        }));
    }

    private static Future<ColumnData> sampleData(DataGenerator dataGenerator, int x, int z, int width, int height) {
        DataView view = DataView.rect(x, z, width, height);
        return dataGenerator.generate(view, TerrainMesh.REQUIRED_DATA);
    }

    public void upload() {
        this.mesh.upload();
    }

    public void render() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.translation.field_72450_a, (double)this.translation.field_72448_b, (double)this.translation.field_72449_c);
        this.mesh.render();
        GlStateManager.func_179121_F();
    }

    public void delete() {
        this.mesh.delete();
    }

    private static short computeOriginHeight(ShortRaster heightRaster) {
        short[] shortData;
        long total = 0L;
        long maxHeight = 0L;
        for (short value : shortData = (short[])heightRaster.getData()) {
            if ((long)value > maxHeight) {
                maxHeight = value;
            }
            total += (long)value;
        }
        long averageHeight = total / (long)shortData.length;
        return (short)((averageHeight + maxHeight + maxHeight) / 3L);
    }
}

