/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.widget.map;

import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SlippyMapPoint {
    private final double latitude;
    private final double longitude;

    public SlippyMapPoint(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public SlippyMapPoint(int x, int y, int zoom) {
        double maximumX = 256 * (1 << zoom);
        this.longitude = (double)x / maximumX * 360.0 - 180.0;
        double maximumY = 256 * (1 << zoom);
        this.latitude = Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * (double)y / maximumY)));
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getX(int zoom) {
        double maximumX = 256 * (1 << zoom);
        return MathHelper.func_76128_c((double)((this.longitude + 180.0) / 360.0 * maximumX));
    }

    public int getY(int zoom) {
        double maximumY = 256 * (1 << zoom);
        double angle = Math.toRadians(this.latitude);
        return MathHelper.func_76128_c((double)((1.0 - Math.log(Math.tan(angle) + 1.0 / Math.cos(angle)) / Math.PI) / 2.0 * maximumY));
    }

    public SlippyMapPoint translate(int x, int y, int zoom) {
        int currentX = this.getX(zoom);
        int currentY = this.getY(zoom);
        return new SlippyMapPoint(currentX + x, currentY + y, zoom);
    }
}

