/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.widget.map;

import java.awt.image.BufferedImage;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapTilePos;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SlippyMapTile {
    private final SlippyMapTilePos pos;
    private final Object lock = new Object();
    private float transition;
    private BufferedImage image;
    private ResourceLocation location;

    public SlippyMapTile(SlippyMapTilePos pos) {
        this.pos = pos;
    }

    public void update(float partialTicks) {
        if (this.transition < 1.0f) {
            this.transition = MathHelper.func_76131_a((float)(this.transition + partialTicks * 0.1f), (float)0.0f, (float)1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyImage(BufferedImage image) {
        Object object = this.lock;
        synchronized (object) {
            this.image = image;
        }
    }

    public ResourceLocation getLocation() {
        if (this.location == null && this.image != null) {
            this.location = this.uploadImage();
        }
        return this.location;
    }

    public float getTransition() {
        return this.transition;
    }

    public void delete() {
        Minecraft.func_71410_x().func_110434_K().func_147645_c(this.location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceLocation uploadImage() {
        Object object = this.lock;
        synchronized (object) {
            BufferedImage image = this.image;
            this.image = null;
            DynamicTexture texture = new DynamicTexture(image);
            return Minecraft.func_71410_x().func_110434_K().func_110578_a("terrarium_map_" + this.pos.toString(), texture);
        }
    }

    public boolean isReady() {
        return this.getLocation() != null;
    }
}

