/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.widget.map;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.gegy1000.earth.client.gui.widget.map.SlippyMap;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapPoint;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapTile;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapTilePos;
import net.gegy1000.earth.client.gui.widget.map.component.MapComponent;
import net.gegy1000.terrarium.client.gui.GuiRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SlippyMapWidget
extends Gui {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final String ATTRIBUTION = "\u00a9 OpenStreetMap Contributors";
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final SlippyMap map;
    private final List<MapComponent> components = new ArrayList<MapComponent>();
    private int prevMouseX;
    private int prevMouseY;
    private boolean mouseDown;
    private boolean mouseDragged;

    public SlippyMapWidget(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.map = new SlippyMap(width, height);
    }

    public SlippyMap getMap() {
        return this.map;
    }

    public <T extends MapComponent> T addComponent(T component) {
        this.components.add(component);
        return component;
    }

    public void draw(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179098_w();
        this.drawBackground();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
        ScaledResolution resolution = new ScaledResolution(MC);
        float scale = 1.0f / (float)resolution.func_78325_e();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        int cameraX = this.map.getCameraX();
        int cameraY = this.map.getCameraY();
        int cameraZoom = this.map.getCameraZoom();
        GL11.glEnable((int)3089);
        GuiRenderUtils.scissor((double)this.x + 4.0, (double)this.y + 4.0, (double)this.width - 8.0, (double)this.height - 8.0);
        List<SlippyMapTilePos> tiles = this.map.getVisibleTiles();
        List<SlippyMapTilePos> cascadedTiles = this.map.cascadeTiles(tiles);
        cascadedTiles.sort(Comparator.comparingInt(SlippyMapTilePos::getZoom));
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        for (SlippyMapTilePos slippyMapTilePos : cascadedTiles) {
            SlippyMapTile tile = this.map.getTile(slippyMapTilePos);
            this.renderTile(cameraX, cameraY, cameraZoom, slippyMapTilePos, tile, partialTicks);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SlippyMapPoint mouse = this.getPointUnderMouse(resolution, mouseX, mouseY);
        for (MapComponent component : this.components) {
            component.onDrawMap(this.map, resolution, mouse);
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
        int n = this.x + this.width - 4;
        int maxY = this.y + this.height - 4;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int attributionWidth = fontRenderer.func_78256_a(ATTRIBUTION) + 20;
        int attributionOriginX = n - attributionWidth;
        int attributionOriginY = maxY - fontRenderer.field_78288_b - 4;
        SlippyMapWidget.func_73734_a((int)attributionOriginX, (int)attributionOriginY, (int)n, (int)maxY, (int)-1072689136);
        fontRenderer.func_78276_b(ATTRIBUTION, attributionOriginX + 10, attributionOriginY + fontRenderer.field_78288_b / 2 - 1, -1);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        int scroll = Mouse.getDWheel();
        if (scroll != 0 && this.isSelected(mouseX, mouseY)) {
            this.map.zoom(MathHelper.func_76125_a((int)scroll, (int)-1, (int)1), mouseX - this.x, mouseY - this.y);
        }
    }

    private void renderTile(int cameraX, int cameraY, int cameraZoom, SlippyMapTilePos pos, SlippyMapTile image, float partialTicks) {
        image.update(partialTicks);
        if (image.getLocation() != null) {
            int deltaZoom = cameraZoom - pos.getZoom();
            double zoomScale = Math.pow(2.0, deltaZoom);
            int size = MathHelper.func_76128_c((double)(256.0 * zoomScale));
            int renderX = (pos.getX() << deltaZoom) * 256 - cameraX;
            int renderY = (pos.getY() << deltaZoom) * 256 - cameraY;
            MC.func_110434_K().func_110577_a(image.getLocation());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)image.getTransition());
            Gui.func_152125_a((int)renderX, (int)renderY, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)size, (int)size, (float)256.0f, (float)256.0f);
        }
    }

    private void drawBackground() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        MC.func_110434_K().func_110577_a(Gui.field_110325_k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float textureSize = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)(this.x + this.width), (double)this.y, 0.0).func_187315_a((double)((float)(this.x + this.width) / textureSize), (double)((float)this.y / textureSize)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.x, (double)this.y, 0.0).func_187315_a((double)((float)this.x / textureSize), (double)((float)this.y / textureSize)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.x, (double)(this.y + this.height), 0.0).func_187315_a((double)((float)this.x / textureSize), (double)((float)(this.y + this.height) / textureSize)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)(this.x + this.width), (double)(this.y + this.height), 0.0).func_187315_a((double)((float)(this.x + this.width) / textureSize), (double)((float)(this.y + this.height) / textureSize)).func_181669_b(32, 32, 32, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
        if (this.isSelected(mouseX, mouseY)) {
            this.mouseDown = true;
            if (mouseButton == 0) {
                ScaledResolution resolution = new ScaledResolution(MC);
                SlippyMapPoint mouse = this.getPointUnderMouse(resolution, mouseX, mouseY);
                for (MapComponent component : this.components) {
                    component.onMouseClicked(this.map, mouse);
                }
            }
        }
    }

    public void mouseDragged(int mouseX, int mouseY, int mouseButton) {
        if (this.mouseDown) {
            int deltaX = this.prevMouseX - mouseX;
            int deltaY = this.prevMouseY - mouseY;
            this.map.drag(deltaX, deltaY);
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
            this.mouseDragged = true;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.mouseDown && !this.mouseDragged && this.isSelected(mouseX, mouseY)) {
            ScaledResolution resolution = new ScaledResolution(MC);
            SlippyMapPoint mouse = this.getPointUnderMouse(resolution, mouseX, mouseY);
            for (MapComponent component : this.components) {
                component.onMouseReleased(this.map, mouse);
            }
        }
        this.mouseDown = false;
        this.mouseDragged = false;
    }

    public void close() {
        this.map.shutdown();
    }

    private SlippyMapPoint getPointUnderMouse(ScaledResolution resolution, int mouseX, int mouseY) {
        int scale = resolution.func_78325_e();
        int mapX = (mouseX - this.x) * scale + this.map.getCameraX();
        int mapY = (mouseY - this.y) * scale + this.map.getCameraY();
        return new SlippyMapPoint(mapX, mapY, this.map.getCameraZoom());
    }

    private boolean isSelected(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.width && mouseY <= this.y + this.height;
    }
}

