/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.widget.map.component;

import net.gegy1000.earth.client.gui.widget.map.SlippyMap;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapPoint;
import net.gegy1000.earth.client.gui.widget.map.component.MapComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MarkerMapComponent
implements MapComponent {
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("terrarium", "textures/gui/widgets.png");
    private SlippyMapPoint marker;
    private boolean canMove;
    private float offsetX = 0.0f;
    private float offsetY = 32.0f;
    private boolean visible = true;

    public MarkerMapComponent(SlippyMapPoint marker) {
        this.marker = marker;
    }

    public MarkerMapComponent() {
        this(null);
    }

    public MarkerMapComponent allowMovement() {
        this.canMove = true;
        return this;
    }

    @Override
    public void onDrawMap(SlippyMap map, ScaledResolution resolution, SlippyMapPoint mouse) {
        if (this.marker != null && this.visible) {
            int scale = resolution.func_78325_e();
            int markerX = this.marker.getX(map.getCameraZoom()) - map.getCameraX();
            int markerY = this.marker.getY(map.getCameraZoom()) - map.getCameraY();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS_TEXTURE);
            Gui.func_152125_a((int)(markerX - 5 * scale), (int)(markerY - 10 * scale), (float)this.offsetX, (float)this.offsetY, (int)16, (int)16, (int)(10 * scale), (int)(10 * scale), (float)256.0f, (float)256.0f);
        }
    }

    @Override
    public void onMouseReleased(SlippyMap map, SlippyMapPoint mouse) {
        if (this.canMove) {
            this.marker = mouse;
        }
    }

    public void moveMarker(double latitude, double longitude) {
        this.marker = new SlippyMapPoint(latitude, longitude);
    }

    public SlippyMapPoint getMarker() {
        return this.marker;
    }

    public void setOffsetX(float x) {
        this.offsetX = x;
    }

    public void setOffsetY(float y) {
        this.offsetY = y;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

