/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.render;

import java.lang.reflect.Field;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.client.LoadingWorldGetter;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.client.gui.GuiRenderUtils;
import net.minecraft.client.LoadingScreenRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="terrarium", value={Side.CLIENT})
public class LoadingScreenOverlay {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final String[] ATTRIBUTION = new String[]{TextFormatting.GRAY + "NASADEM: NASA/JPL-Caltech", TextFormatting.GRAY + "LandCover: ESA Climate Change Initiative", TextFormatting.GRAY + "GEBCO Compilation Group", TextFormatting.GRAY + "SoilGrids: ISRIC World Soil Info", TextFormatting.GRAY + "WorldClim, iNaturalist, OpenStreetMap"};
    private static Field framebufferField;

    public static void onRender() {
        if (LoadingWorldGetter.getLoadingWorldType() == TerrariumEarth.WORLD_TYPE) {
            ScaledResolution resolution = new ScaledResolution(MC);
            int x = resolution.func_78326_a() / 2;
            int y = resolution.func_78328_b() - 13 - ATTRIBUTION.length * 9;
            String header = TextFormatting.YELLOW.toString() + TextFormatting.BOLD + I18n.func_135052_a((String)"gui.earth.credits", (Object[])new Object[0]);
            GuiRenderUtils.drawCenteredString(header, x, y, 0xFFFFFF);
            for (int i = 0; i < ATTRIBUTION.length; ++i) {
                GuiRenderUtils.drawCenteredString(ATTRIBUTION[i], x, y + 11 + i * 9, 0xFFFFFF);
            }
        }
    }

    @SubscribeEvent
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (LoadingScreenOverlay.MC.field_71462_r instanceof GuiDownloadTerrain || LoadingScreenOverlay.MC.field_71462_r instanceof GuiScreenWorking) {
            LoadingScreenOverlay.onRender();
        }
    }

    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        try {
            LoadingScreenOverlay.hookFramebuffer();
        }
        catch (Exception e) {
            Terrarium.LOGGER.warn("Failed to hook LoadingScreenRenderer framebuffer", (Throwable)e);
        }
    }

    public static void onPostInit() {
        try {
            framebufferField = LoadingScreenOverlay.reflectFramebufferField();
        }
        catch (Exception e) {
            Terrarium.LOGGER.warn("Failed to reflect LoadingScreenRenderer framebuffer", (Throwable)e);
        }
    }

    private static Field reflectFramebufferField() throws Exception {
        Field framebufferField = null;
        for (Field field : LoadingScreenRenderer.class.getDeclaredFields()) {
            if (field.getType() != Framebuffer.class) continue;
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            framebufferField = field;
        }
        if (framebufferField == null) {
            throw new ReflectiveOperationException("Could not find Framebuffer field to hook");
        }
        return framebufferField;
    }

    private static void hookFramebuffer() throws Exception {
        LoadingScreenRenderer loadingScreen;
        Framebuffer delegate;
        if (framebufferField != null && !LoadingScreenOverlay.checkHooked(delegate = (Framebuffer)framebufferField.get(loadingScreen = Minecraft.func_71410_x().field_71461_s))) {
            framebufferField.set(loadingScreen, (Object)new HookedFramebuffer(delegate));
        }
    }

    private static boolean checkHooked(Framebuffer framebuffer) {
        return framebuffer instanceof HookedFramebuffer;
    }

    private static class HookedFramebuffer
    extends Framebuffer {
        private final Framebuffer delegate;

        private HookedFramebuffer(Framebuffer delegate) {
            super(delegate.field_147621_c, delegate.field_147618_d, delegate.field_147619_e);
            this.delegate = delegate;
        }

        public void func_147613_a(int width, int height) {
            if (this.delegate != null) {
                this.delegate.func_147613_a(width, height);
            } else {
                super.func_147613_a(width, height);
            }
        }

        public void func_147608_a() {
            if (this.delegate != null) {
                this.delegate.func_147608_a();
            } else {
                super.func_147608_a();
            }
        }

        public void func_147605_b(int width, int height) {
            if (this.delegate != null) {
                this.delegate.func_147605_b(width, height);
            } else {
                this.field_147621_c = width;
                this.field_147618_d = height;
                this.field_147622_a = width;
                this.field_147620_b = height;
            }
        }

        public void func_147607_a(int framebufferFilter) {
            this.delegate.func_147607_a(framebufferFilter);
        }

        public void func_147611_b() {
            if (this.delegate != null) {
                this.delegate.func_147611_b();
            }
        }

        public void func_147612_c() {
            this.delegate.func_147612_c();
        }

        public void func_147606_d() {
            this.delegate.func_147606_d();
        }

        public void func_147610_a(boolean viewport) {
            this.delegate.func_147610_a(viewport);
        }

        public void func_147609_e() {
            LoadingScreenOverlay.onRender();
            this.delegate.func_147609_e();
        }

        public void func_147604_a(float red, float green, float blue, float alpha) {
            this.delegate.func_147604_a(red, green, blue, alpha);
        }

        public void func_147615_c(int width, int height) {
            this.delegate.func_147615_c(width, height);
        }

        public void func_178038_a(int width, int height, boolean material) {
            this.delegate.func_178038_a(width, height, material);
        }

        public void func_147614_f() {
            this.delegate.func_147614_f();
        }

        public boolean enableStencil() {
            return this.delegate.enableStencil();
        }

        public boolean isStencilEnabled() {
            return this.delegate.isStencilEnabled();
        }
    }
}

