/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.render;

import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.world.data.GooglePanorama;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;

public class Panorama {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final int BASE_PANORAMA_WIDTH = 416;
    private static final int TILE_SIZE = 512;
    private final GooglePanorama panorama;
    private final ResourceLocation textureLocation;
    private final DynamicTexture texture;
    private final int stitchedWidth;
    private final int stitchedHeight;
    private final int zoom;
    private final AtomicBoolean textureDirty = new AtomicBoolean();
    private final AtomicBoolean loaded = new AtomicBoolean();

    public Panorama(GooglePanorama panorama, String suffix, int zoom) {
        this.panorama = panorama;
        this.textureLocation = new ResourceLocation("earth", "panorama_" + panorama.getId() + "_" + suffix);
        this.zoom = zoom;
        this.stitchedWidth = (1 << this.zoom) * 416;
        this.stitchedHeight = this.stitchedWidth / 2;
        this.texture = new DynamicTexture(this.stitchedWidth, this.stitchedHeight);
        MC.func_110434_K().func_110579_a(this.textureLocation, (ITextureObject)this.texture);
        Thread thread = new Thread(this::loadTiles);
        thread.setName("Panorama Load Thread");
        thread.setDaemon(true);
        thread.start();
    }

    private void loadTiles() {
        int tileCountX = (int)Math.ceil((double)this.stitchedWidth / 512.0);
        int tileCountY = (int)Math.ceil((double)this.stitchedHeight / 512.0);
        for (int tileY = 0; tileY < tileCountY; ++tileY) {
            for (int tileX = 0; tileX < tileCountX; ++tileX) {
                try {
                    BufferedImage image = this.panorama.loadTile(tileX, tileY, this.zoom);
                    this.stitchTile(tileX, tileY, image);
                    continue;
                }
                catch (Exception e) {
                    TerrariumEarth.LOGGER.error("Failed to load panorama tile at {} {}", (Object)tileX, (Object)tileY, (Object)e);
                }
            }
        }
        this.loaded.set(true);
    }

    private void stitchTile(int tileX, int tileY, BufferedImage image) {
        int originX = tileX * 512;
        int originY = tileY * 512;
        int maxX = Math.min(image.getWidth(), this.stitchedWidth - originX);
        int maxY = Math.min(image.getHeight(), this.stitchedHeight - originY);
        int[] data = this.texture.func_110565_c();
        for (int localY = 0; localY < maxY; ++localY) {
            for (int localX = 0; localX < maxX; ++localX) {
                int globalX = originX + localX;
                int globalY = originY + localY;
                data[globalX + globalY * this.stitchedWidth] = image.getRGB(localX, localY);
            }
        }
        this.textureDirty.set(true);
    }

    public ResourceLocation getTextureLocation() {
        if (this.textureDirty.get()) {
            this.textureDirty.set(false);
            this.texture.func_110564_a();
        }
        return this.textureLocation;
    }

    public void delete() {
        MC.func_110434_K().func_147645_c(this.textureLocation);
    }

    public boolean hasLoaded() {
        return this.loaded.get();
    }
}

