/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.render;

import javax.annotation.Nullable;
import net.gegy1000.earth.client.render.Panorama;
import net.gegy1000.earth.server.config.TerrariumEarthConfig;
import net.gegy1000.earth.server.world.data.GooglePanorama;
import net.gegy1000.terrarium.server.util.FlipFlopTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Sphere;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="earth", value={Side.CLIENT})
public class PanoramaHandler {
    private static final String ATTRIBUTION = "\u00a9 Google Street View";
    public static final double IMMERSION_MIN_DISTANCE = 2.25;
    private static State state = null;
    private static double lastTicks;

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        lastTicks = event.getWorld().func_82737_E();
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && state != null) {
            state.renderGui(Minecraft.func_71410_x(), event.getResolution(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (state != null && event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player != null) {
                State newState = state.update(player.field_70170_p, (EntityPlayer)player);
                if (newState != state) {
                    state.delete();
                }
                state = newState;
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        if (state != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179127_m();
            GlStateManager.func_179089_o();
            GlStateManager.func_179098_w();
            RenderHelper.func_74519_b();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            float partialTicks = event.getPartialTicks();
            double ticks = (float)world.func_82737_E() + partialTicks;
            state.renderWorld(Minecraft.func_71410_x(), partialTicks, (float)(ticks - lastTicks));
            lastTicks = ticks;
            GlStateManager.func_179106_n();
        }
    }

    public static void setState(State newState) {
        if (state != null) {
            state.delete();
        }
        state = newState;
    }

    public static class Immersed
    implements State {
        private static final int SPHERE_RESOLUTION = 32;
        private static final float SPHERE_RADIUS = 8.0f;
        private final GooglePanorama panoramaId;
        private final double originX;
        private final double originY;
        private final double originZ;
        private Panorama basePanorama;
        private Panorama fullPanorama;
        private final Sphere sphere;
        private int sphereDisplayList = Integer.MIN_VALUE;
        private final FlipFlopTimer fadeAnimation = new FlipFlopTimer(0.1f);
        private boolean loadedBase;

        public Immersed(GooglePanorama panoramaId, double originX, double originY, double originZ) {
            this.panoramaId = panoramaId;
            this.originX = originX;
            this.originY = originY;
            this.originZ = originZ;
            this.basePanorama = new Panorama(panoramaId, "base", 0);
            this.sphere = new Sphere();
            this.sphere.setTextureFlag(true);
            this.sphere.setOrientation(100021);
            this.sphere.setNormals(100002);
        }

        @Override
        public void renderWorld(Minecraft mc, float partialTicks, float deltaTicks) {
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            this.updateAnimation(deltaTicks);
            double renderX = this.originX - TileEntityRendererDispatcher.field_147554_b;
            double renderY = this.originY - TileEntityRendererDispatcher.field_147555_c;
            double renderZ = this.originZ - TileEntityRendererDispatcher.field_147552_d;
            GlStateManager.func_179137_b((double)renderX, (double)renderY, (double)renderZ);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float fadeValue = this.fadeAnimation.getValue();
            float scale = (1.0f - fadeValue) * 1.4f + 1.0f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)fadeValue);
            if (this.sphereDisplayList == Integer.MIN_VALUE) {
                this.sphereDisplayList = GLAllocation.func_74526_a((int)1);
                GlStateManager.func_187423_f((int)this.sphereDisplayList, (int)4864);
                this.sphere.draw(8.0f, 32, 32);
                GlStateManager.func_187415_K();
            }
            if (this.basePanorama != null) {
                mc.func_110434_K().func_110577_a(this.basePanorama.getTextureLocation());
                GlStateManager.func_179148_o((int)this.sphereDisplayList);
            }
            if (this.fullPanorama != null) {
                mc.func_110434_K().func_110577_a(this.fullPanorama.getTextureLocation());
                GlStateManager.func_179148_o((int)this.sphereDisplayList);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
            GlStateManager.func_179145_e();
        }

        @Override
        public void renderGui(Minecraft mc, ScaledResolution resolution, float partialTicks) {
            FontRenderer fontRenderer = mc.field_71466_p;
            int attributionMaxX = fontRenderer.func_78256_a(PanoramaHandler.ATTRIBUTION) + 10;
            int attributionOriginY = resolution.func_78328_b() - fontRenderer.field_78288_b - 4;
            Gui.func_73734_a((int)0, (int)attributionOriginY, (int)attributionMaxX, (int)resolution.func_78328_b(), (int)-1072689136);
            fontRenderer.func_78276_b(PanoramaHandler.ATTRIBUTION, 5, attributionOriginY + fontRenderer.field_78288_b / 2 - 1, -1);
        }

        private void updateAnimation(float deltaTicks) {
            this.fadeAnimation.update(deltaTicks);
            if (this.basePanorama != null && this.basePanorama.hasLoaded() && !this.loadedBase) {
                this.fadeAnimation.setTarget(FlipFlopTimer.Side.RIGHT);
                this.loadedBase = true;
            }
            if (this.fadeAnimation.isRight() && this.loadedBase) {
                if (this.fullPanorama == null) {
                    this.fullPanorama = new Panorama(this.panoramaId, "full", TerrariumEarthConfig.streetViewZoom);
                } else if (this.basePanorama != null && this.fullPanorama.hasLoaded()) {
                    this.basePanorama.delete();
                    this.basePanorama = null;
                }
            }
        }

        @Override
        @Nullable
        public State update(World world, EntityPlayer player) {
            double maxDistance;
            double deltaZ;
            double deltaY;
            double deltaX;
            if (this.fadeAnimation.isRight() && (deltaX = player.field_70165_t - this.originX) * deltaX + (deltaY = player.field_70163_u - this.originY) * deltaY + (deltaZ = player.field_70161_v - this.originZ) * deltaZ > (maxDistance = 1.6) * maxDistance) {
                this.fadeAnimation.setTarget(FlipFlopTimer.Side.LEFT);
            }
            if (this.fadeAnimation.hasMoved() && this.fadeAnimation.isLeft()) {
                return null;
            }
            return this;
        }

        @Override
        public void delete() {
            if (this.basePanorama != null) {
                this.basePanorama.delete();
            }
            if (this.fullPanorama != null) {
                this.fullPanorama.delete();
            }
            GlStateManager.func_187449_e((int)this.sphereDisplayList, (int)1);
        }
    }

    public static class Located
    implements State {
        private final GooglePanorama panorama;
        private final double blockX;
        private final double blockZ;

        public Located(GooglePanorama panorama, double blockX, double blockZ) {
            this.panorama = panorama;
            this.blockX = blockX;
            this.blockZ = blockZ;
        }

        @Override
        public void renderWorld(Minecraft mc, float partialTicks, float deltaTicks) {
            double deltaX = this.blockX - TileEntityRendererDispatcher.field_147554_b;
            double deltaZ = this.blockZ - TileEntityRendererDispatcher.field_147552_d;
            double y = -TileEntityRendererDispatcher.field_147555_c;
            long worldTime = mc.field_71441_e.func_82737_E();
            GlStateManager.func_179106_n();
            mc.func_110434_K().func_110577_a(TileEntityBeaconRenderer.field_147523_b);
            TileEntityBeaconRenderer.func_188204_a((double)deltaX, (double)y, (double)deltaZ, (double)partialTicks, (double)1.0, (double)worldTime, (int)0, (int)256, (float[])new float[]{0.2f, 1.0f, 0.2f});
            GlStateManager.func_179127_m();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        @Nullable
        public State update(World world, EntityPlayer player) {
            double deltaX = player.field_70165_t - this.blockX;
            double deltaZ = player.field_70161_v - this.blockZ;
            if (deltaX * deltaX + deltaZ * deltaZ < 2.25) {
                return new Immersed(this.panorama, this.blockX, player.field_70163_u, this.blockZ);
            }
            return this;
        }
    }

    public static interface State {
        default public void renderWorld(Minecraft mc, float partialTicks, float deltaTicks) {
        }

        default public void renderGui(Minecraft mc, ScaledResolution resolution, float partialTicks) {
        }

        default public void delete() {
        }

        @Nullable
        default public State update(World world, EntityPlayer player) {
            return this;
        }
    }
}

