/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.terrain;

import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.Set;
import javax.vecmath.Vector3f;
import net.gegy1000.earth.client.terrain.TerrainColorizer;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.terrarium.client.render.TerrariumVertexFormats;
import net.gegy1000.terrarium.server.world.data.ColumnData;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.gegy1000.terrarium.server.world.data.raster.FloatRaster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.WorldVertexBufferUploader;

public final class TerrainMesh {
    public static final Set<DataKey<?>> REQUIRED_DATA = Sets.newHashSet((Object[])new DataKey[]{EarthData.TERRAIN_HEIGHT, EarthData.SLOPE, EarthData.MIN_TEMPERATURE, EarthData.COVER});
    private static final Vector3f NORMAL_STORE = new Vector3f();
    private BufferBuilder buffer;
    private int displayList = -1;

    private TerrainMesh(BufferBuilder buffer) {
        this.buffer = buffer;
    }

    public void upload() {
        if (this.buffer == null) {
            return;
        }
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        new WorldVertexBufferUploader().func_181679_a(this.buffer);
        GlStateManager.func_187415_K();
        this.buffer = null;
    }

    public void render() {
        if (this.displayList != -1) {
            GlStateManager.func_179148_o((int)this.displayList);
        }
    }

    public static TerrainMesh build(ColumnData data, BufferBuilder builder, int granularity) {
        builder.func_181668_a(7, TerrariumVertexFormats.POSITION_COLOR_NORMAL);
        ShortRaster heightRaster = data.getOrDefault(EarthData.TERRAIN_HEIGHT);
        UByteRaster slopeRaster = data.getOrDefault(EarthData.SLOPE);
        FloatRaster minTemperatureRaster = data.getOrDefault(EarthData.MIN_TEMPERATURE);
        EnumRaster<Cover> coverRaster = data.getOrDefault(EarthData.COVER);
        int width = heightRaster.getWidth();
        int height = heightRaster.getHeight();
        short[] heightBuffer = (short[])heightRaster.getData();
        int strideX = granularity;
        int strideY = width * granularity;
        for (int localZ = 0; localZ < height - granularity; localZ += granularity) {
            for (int localX = 0; localX < width - granularity; localX += granularity) {
                int index = localX + localZ * width;
                short topLeft = heightBuffer[index];
                short topRight = heightBuffer[index + strideX];
                short bottomLeft = heightBuffer[index + strideY];
                short bottomRight = heightBuffer[index + strideX + strideY];
                Cover cover = coverRaster.get(localX, localZ);
                int slope = slopeRaster.get(localX, localZ);
                float minTemperature = minTemperatureRaster.get(localX, localZ);
                Color color = TerrainColorizer.get(cover, slope, minTemperature);
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                Vector3f normal = TerrainMesh.computeNormal(topLeft, topRight, bottomLeft);
                float nx = normal.x;
                float ny = normal.y;
                float nz = normal.z;
                builder.func_181662_b((double)localX, (double)bottomLeft, (double)(localZ + granularity)).func_181669_b(red, green, blue, 255).func_181663_c(nx, ny, nz).func_181675_d();
                builder.func_181662_b((double)(localX + granularity), (double)bottomRight, (double)(localZ + granularity)).func_181669_b(red, green, blue, 255).func_181663_c(nx, ny, nz).func_181675_d();
                builder.func_181662_b((double)(localX + granularity), (double)topRight, (double)localZ).func_181669_b(red, green, blue, 255).func_181663_c(nx, ny, nz).func_181675_d();
                builder.func_181662_b((double)localX, (double)topLeft, (double)localZ).func_181669_b(red, green, blue, 255).func_181663_c(nx, ny, nz).func_181675_d();
            }
        }
        builder.func_178977_d();
        return new TerrainMesh(builder);
    }

    public static int computeBufferSize(int width, int height, int granularity) {
        int vertexWidth = TerrariumVertexFormats.POSITION_COLOR_NORMAL.func_177338_f();
        int quadCountX = (width - granularity) / granularity;
        int quadCountZ = (height - granularity) / granularity;
        int vertexCount = quadCountX * quadCountZ * 4;
        return vertexCount * vertexWidth;
    }

    private static Vector3f computeNormal(int topLeft, int topRight, int bottomLeft) {
        NORMAL_STORE.set((float)(topLeft - topRight), 1.0f, (float)(topLeft - bottomLeft));
        NORMAL_STORE.normalize();
        return NORMAL_STORE;
    }

    public void delete() {
        if (this.displayList != -1) {
            GLAllocation.func_74523_b((int)this.displayList);
            this.displayList = -1;
        }
        this.buffer = null;
    }
}

