/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.EarthInitContext;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.coordinate.CoordinateReference;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.source.Geocoder;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public interface EarthWorld
extends ICapabilityProvider {
    public static final double EQUATOR_CIRCUMFERENCE = 4.0075017E7;
    public static final int LOWEST_POINT_METERS = -11100;
    public static final int HIGHEST_POINT_METERS = 8900;

    @Nullable
    public static EarthWorld get(World world) {
        return (EarthWorld)world.getCapability(TerrariumEarth.worldCap(), null);
    }

    public Geocoder getGeocoder();

    public CoordinateReference getCrs();

    @Nullable
    public BlockPos estimateSurface(World var1, int var2, int var3);

    default public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == TerrariumEarth.worldCap();
    }

    @Nullable
    default public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == TerrariumEarth.worldCap() ? TerrariumEarth.worldCap().cast((Object)this) : null);
    }

    public static class Impl
    implements EarthWorld {
        private final CoordinateReference crs;
        private final Geocoder geocoder;

        public Impl(GenerationSettings settings) {
            this.crs = EarthInitContext.from((GenerationSettings)settings).lngLatCrs;
            this.geocoder = TerrariumEarth.getPreferredGeocoder();
        }

        @Override
        public Geocoder getGeocoder() {
            return this.geocoder;
        }

        @Override
        public CoordinateReference getCrs() {
            return this.crs;
        }

        @Override
        @Nullable
        public BlockPos estimateSurface(World world, int blockX, int blockZ) {
            TerrariumWorld terrarium = TerrariumWorld.get(world);
            if (terrarium == null) {
                return null;
            }
            ColumnDataCache dataCache = terrarium.getDataCache();
            ShortRaster.Sampler sampler = ShortRaster.sampler(EarthData.TERRAIN_HEIGHT);
            short height = sampler.sample(dataCache, blockX, blockZ);
            return new BlockPos(blockX, height + 1, blockZ);
        }
    }

    public static class None
    implements EarthWorld {
        @Override
        public Geocoder getGeocoder() {
            return Geocoder.VOID;
        }

        @Override
        public CoordinateReference getCrs() {
            return CoordinateReference.block();
        }

        @Override
        @Nullable
        public BlockPos estimateSurface(World world, int blockX, int blockZ) {
            return world.func_175672_r(new BlockPos(blockX, 0, blockZ));
        }
    }
}

