/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.command;

import java.util.Optional;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.capability.EarthWorld;
import net.gegy1000.earth.server.command.ContainerUi;
import net.gegy1000.earth.server.command.DeferredTranslator;
import net.gegy1000.earth.server.message.EarthOpenMapMessage;
import net.gegy1000.earth.server.message.EarthPanoramaMessage;
import net.gegy1000.earth.server.world.data.DataPreloader;
import net.gegy1000.terrarium.server.TerrariumUserTracker;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GeoToolCommand
extends CommandBase {
    public String func_71517_b() {
        return "geotool";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return DeferredTranslator.translateStringOrKey(sender, "commands.earth.geotool.usage");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ContainerUi.Builder builder;
        EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
        EarthWorld earth = (EarthWorld)player.field_70170_p.getCapability(TerrariumEarth.worldCap(), null);
        if (earth != null) {
            String locate;
            builder = ContainerUi.builder(player).setTitle(DeferredTranslator.translate((ICommandSender)player, (ITextComponent)new TextComponentTranslation("container.earth.geotool.name", new Object[0])));
            if (TerrariumUserTracker.usesTerrarium((EntityPlayer)player)) {
                locate = DeferredTranslator.translateString(sender, "commands.earth.geotool.locate");
                builder.addElement(Items.field_151111_aL, TextFormatting.BOLD + locate, () -> this.openMap(player, earth, EarthOpenMapMessage.Type.LOCATE));
                String displayPanorama = DeferredTranslator.translateString(sender, "commands.earth.geotool.display_panorama");
                builder.addElement(Items.field_151159_an, TextFormatting.BOLD + displayPanorama, () -> this.handlePanorama(player));
                if (DataPreloader.checkPermission(player)) {
                    String preloadWorld = DeferredTranslator.translateString(sender, "commands.earth.geotool.preload_world");
                    builder.addElement(Blocks.field_150483_bI, TextFormatting.BOLD + preloadWorld, () -> this.handlePreload(player, earth));
                }
            } else {
                locate = DeferredTranslator.translateString(sender, "commands.earth.geotool.locate");
                builder.addElement(Items.field_151111_aL, TextFormatting.BOLD + locate, () -> this.handleLocate(player, earth));
            }
        } else {
            throw DeferredTranslator.createException((ICommandSender)player, "commands.earth.wrong_world", new Object[0]);
        }
        ContainerUi ui = builder.build();
        player.func_71007_a((IInventory)ui.createInventory());
    }

    private void handlePanorama(EntityPlayerMP player) {
        TerrariumEarth.NETWORK.sendTo((IMessage)new EarthPanoramaMessage(), player);
    }

    private void handleLocate(EntityPlayerMP player, EarthWorld earth) {
        Coordinate coordinate = Coordinate.atBlock(player.field_70165_t, player.field_70161_v).to(earth.getCrs());
        double longitude = coordinate.getX();
        double latitude = coordinate.getZ();
        String location = TextFormatting.BOLD.toString() + TextFormatting.UNDERLINE + String.format("%.5f, %.5f", latitude, longitude);
        player.func_145747_a(DeferredTranslator.translate((ICommandSender)player, (ITextComponent)new TextComponentTranslation("geotool.earth.locate.success", new Object[]{location})));
    }

    private void handlePreload(EntityPlayerMP player, EarthWorld earth) {
        Optional<DataPreloader> activeOpt = DataPreloader.active();
        if (activeOpt.isPresent()) {
            DataPreloader active = activeOpt.get();
            active.addWatcher(player);
        } else {
            this.openMap(player, earth, EarthOpenMapMessage.Type.PRELOAD);
        }
    }

    private void openMap(EntityPlayerMP player, EarthWorld earth, EarthOpenMapMessage.Type type) {
        Coordinate coordinate = Coordinate.atBlock(player.field_70165_t, player.field_70161_v).to(earth.getCrs());
        double longitude = coordinate.getX();
        double latitude = coordinate.getZ();
        TerrariumEarth.NETWORK.sendTo((IMessage)new EarthOpenMapMessage(latitude, longitude, type), player);
    }
}

