/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.command.debugger;

import java.util.function.Consumer;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.ecology.soil.SoilSuborder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public final class DebugGeoProfile {
    private static final TextComponentString EMPTY = new TextComponentString("");
    public final String name;
    public final double latitude;
    public final double longitude;
    public final float surfaceElevation;
    public final Cover cover;
    public final float meanTemperature;
    public final float minTemperature;
    public final int annualRainfall;
    public final SoilSuborder soilSuborder;
    public final int siltContent;
    public final int sandContent;
    public final int clayContent;
    public final int organicCarbonContent;
    public final int cationExchangeCapacity;
    public final float soilPh;

    DebugGeoProfile(String name, double latitude, double longitude, float surfaceElevation, Cover cover, float meanTemperature, float minTemperature, int annualRainfall, SoilSuborder soilSuborder, int siltContent, int sandContent, int clayContent, int organicCarbonContent, int cationExchangeCapacity, float soilPh) {
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.surfaceElevation = surfaceElevation;
        this.cover = cover;
        this.meanTemperature = meanTemperature;
        this.minTemperature = minTemperature;
        this.annualRainfall = annualRainfall;
        this.soilSuborder = soilSuborder;
        this.siltContent = siltContent;
        this.sandContent = sandContent;
        this.clayContent = clayContent;
        this.organicCarbonContent = organicCarbonContent;
        this.cationExchangeCapacity = cationExchangeCapacity;
        this.soilPh = soilPh;
    }

    public void sendTo(EntityPlayerMP player) {
        String headerFormat = TextFormatting.UNDERLINE.toString() + TextFormatting.BOLD.toString();
        String header = String.format("Profile at %.5f, %.5f (%s)", this.latitude, this.longitude, this.name);
        player.func_145747_a((ITextComponent)new TextComponentString(headerFormat + header));
        player.func_145747_a((ITextComponent)EMPTY);
        this.sendCategory(player, "General", p -> {
            p.func_145747_a(DebugGeoProfile.makeValue("Surface Elevation", "%.1fm", Float.valueOf(this.surfaceElevation)));
            p.func_145747_a(DebugGeoProfile.makeValue("Cover Class", "%s (#%s)", this.cover, this.cover.id));
            p.func_145747_a(DebugGeoProfile.makeValue("Mean Temperature", "%.1fC", Float.valueOf(this.meanTemperature)));
            p.func_145747_a(DebugGeoProfile.makeValue("Min Temperature", "%.1fC", Float.valueOf(this.minTemperature)));
            p.func_145747_a(DebugGeoProfile.makeValue("Annual Rainfall", "%smm", this.annualRainfall));
        });
        this.sendCategory(player, "Soil", p -> {
            p.func_145747_a(DebugGeoProfile.makeValue("Soil Order", "%s", new Object[]{this.soilSuborder.order}));
            p.func_145747_a(DebugGeoProfile.makeValue("Soil Suborder", "%s (#%s)", new Object[]{this.soilSuborder, this.soilSuborder.id}));
            p.func_145747_a(DebugGeoProfile.makeValue("Silt Content", "%s%%", this.siltContent));
            p.func_145747_a(DebugGeoProfile.makeValue("Sand Content", "%s%%", this.sandContent));
            p.func_145747_a(DebugGeoProfile.makeValue("Clay Content", "%s%%", this.clayContent));
            p.func_145747_a(DebugGeoProfile.makeValue("Organic Carbon Content", "%s g/kg", this.organicCarbonContent));
            p.func_145747_a(DebugGeoProfile.makeValue("Cation Exchange Capacity", "%s cmolc/kg", this.cationExchangeCapacity));
            p.func_145747_a(DebugGeoProfile.makeValue("pH", "%s", Float.valueOf(this.soilPh)));
        });
    }

    private void sendCategory(EntityPlayerMP player, String name, Consumer<EntityPlayerMP> send) {
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.UNDERLINE + name));
        player.func_145747_a((ITextComponent)EMPTY);
        send.accept(player);
        player.func_145747_a((ITextComponent)EMPTY);
    }

    private static ITextComponent makeValue(String key, String value, Object ... args) {
        String keyFormat = TextFormatting.AQUA.toString();
        String valueFormat = TextFormatting.RESET.toString();
        return new TextComponentString(" " + keyFormat + key + ": " + valueFormat + String.format(value, args));
    }
}

