/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.integration.bop;

import biomesoplenty.api.biome.BOPBiomes;
import net.gegy1000.earth.server.event.ClassifyBiomeEvent;
import net.gegy1000.earth.server.event.ConfigureFlowersEvent;
import net.gegy1000.earth.server.event.ConfigureTreesEvent;
import net.gegy1000.earth.server.integration.bop.BoPTrees;
import net.gegy1000.earth.server.world.Climate;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.cover.CoverMarkers;
import net.gegy1000.earth.server.world.cover.CoverSelectors;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.soil.SoilSelector;
import net.gegy1000.earth.server.world.ecology.vegetation.TreeDecorator;
import net.gegy1000.earth.server.world.ecology.vegetation.Trees;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.event.TerrariumInitializeGeneratorEvent;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class BoPIntegration {
    public static void setup() {
        MinecraftForge.TERRAIN_GEN_BUS.register(BoPIntegration.class);
        MinecraftForge.EVENT_BUS.register(BoPIntegration.class);
    }

    @SubscribeEvent
    public static void onConfigureTrees(ConfigureTreesEvent event) {
        TerrariumWorld terrarium = event.getTerrarium();
        if (!terrarium.getSettings().getBoolean(EarthProperties.BOP_INTEGRATION)) {
            return;
        }
        Cover cover = event.getCover();
        TreeDecorator.Builder trees = event.getBuilder();
        if (cover.is(CoverSelectors.broadleafDeciduous())) {
            trees.addCandidate(BoPTrees.MAHOGANY);
            trees.addCandidate(BoPTrees.WILLOW);
        }
        if (cover.is(CoverSelectors.broadleafEvergreen())) {
            trees.addCandidate(BoPTrees.PALM);
            trees.addCandidate(BoPTrees.EUCALYPTUS);
            trees.addCandidate(BoPTrees.MANGROVE);
            trees.addCandidate(BoPTrees.EBONY);
        }
        if (cover.is(CoverSelectors.needleleafEvergreen())) {
            trees.addCandidate(BoPTrees.FIR);
        }
    }

    @SubscribeEvent
    public static void onConfigureFlowers(ConfigureFlowersEvent event) {
    }

    @SubscribeEvent
    public static void onClassifyBiome(ClassifyBiomeEvent event) {
        TerrariumWorld terrarium = event.getTerrarium();
        if (!terrarium.getSettings().getBoolean(EarthProperties.BOP_INTEGRATION)) {
            return;
        }
        GrowthPredictors predictors = event.getPredictors();
        if (!predictors.isFrozen()) {
            double spruce;
            double mangrove;
            if (predictors.cover == Cover.LICHENS_AND_MOSSES) {
                event.setBiome((Biome)BOPBiomes.tundra.orNull());
                return;
            }
            if (predictors.cover == Cover.GRASSLAND) {
                event.setBiome((Biome)BOPBiomes.grassland.orNull());
                return;
            }
            if (predictors.cover.is(CoverMarkers.DENSE_SHRUBS) && Climate.isVeryDry(predictors.annualRainfall)) {
                if (predictors.isBarren() || SoilSelector.isDesertLike(predictors)) {
                    event.setBiome((Biome)BOPBiomes.brushland.orNull());
                } else {
                    event.setBiome((Biome)BOPBiomes.xeric_shrubland.orNull());
                }
                return;
            }
            if (predictors.isLand() && !predictors.cover.is(CoverMarkers.NO_VEGETATION) && (mangrove = (double)BoPTrees.Indicators.MANGROVE.evaluate(predictors)) > 0.85) {
                event.setBiome((Biome)BOPBiomes.mangrove.orNull());
                return;
            }
            if (predictors.slope >= 60 && !predictors.isCold() && predictors.cover.is(CoverMarkers.FOREST)) {
                event.setBiome((Biome)BOPBiomes.overgrown_cliffs.orNull());
                return;
            }
            if (predictors.isFlooded() && event.getBiome() == Biomes.field_76780_h && (spruce = (double)Trees.Indicators.SPRUCE.evaluate(predictors)) > 0.85) {
                event.setBiome((Biome)BOPBiomes.wetland.orNull());
                return;
            }
            if (predictors.isForested() && event.getBiome() == Biomes.field_76782_w) {
                double jungle = Trees.Indicators.JUNGLE_LIKE.evaluate(predictors);
                double oak = Trees.Indicators.OAK.evaluate(predictors);
                double spruce2 = Trees.Indicators.SPRUCE.evaluate(predictors);
                double mahogany = BoPTrees.Indicators.MAHOGANY.evaluate(predictors);
                if (oak > jungle && oak > spruce2 && oak > mahogany) {
                    event.setBiome((Biome)BOPBiomes.rainforest.orNull());
                    return;
                }
                if (spruce2 > jungle && spruce2 > oak && spruce2 > mahogany) {
                    event.setBiome((Biome)BOPBiomes.temperate_rainforest.orNull());
                    return;
                }
                if (mahogany > jungle && mahogany > spruce2 && mahogany > oak) {
                    event.setBiome((Biome)BOPBiomes.tropical_rainforest.orNull());
                    return;
                }
            }
        }
        if (predictors.isForested()) {
            BoPIntegration.classifyForest(event, predictors);
            return;
        }
    }

    private static void classifyForest(ClassifyBiomeEvent event, GrowthPredictors predictors) {
        double fir;
        if (event.getBiome() == Biomes.field_76767_f && predictors.isFrozen()) {
            event.setBiome((Biome)BOPBiomes.snowy_forest.orNull());
            return;
        }
        if (!predictors.isFrozen()) {
            double eucalyptus = BoPTrees.Indicators.EUCALYPTUS.evaluate(predictors);
            if (eucalyptus > 0.85) {
                event.setBiome((Biome)BOPBiomes.eucalyptus_forest.orNull());
                return;
            }
            double birch = Trees.Indicators.BIRCH.evaluate(predictors);
            double spruce = Trees.Indicators.SPRUCE.evaluate(predictors);
            if (birch > 0.85 && spruce > 0.85) {
                event.setBiome((Biome)BOPBiomes.boreal_forest.orNull());
                return;
            }
        }
        if ((fir = (double)BoPTrees.Indicators.FIR.evaluate(predictors)) > 0.85) {
            if (predictors.isFrozen()) {
                event.setBiome((Biome)BOPBiomes.snowy_coniferous_forest.orNull());
            } else {
                event.setBiome((Biome)BOPBiomes.coniferous_forest.orNull());
            }
            return;
        }
    }

    @SubscribeEvent
    public static void onInitializeTerrariumGenerator(TerrariumInitializeGeneratorEvent event) {
    }
}

