/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.util.debug;

import java.io.IOException;
import java.util.Random;
import javax.annotation.Nullable;
import net.gegy1000.earth.server.util.debug.RasterDebug;
import net.gegy1000.earth.server.world.data.GooglePanorama;
import net.minecraft.util.math.MathHelper;

final class PanoramaProfileDebug {
    private static final int COUNT = 20;

    PanoramaProfileDebug() {
    }

    public static void main(String[] args) throws IOException {
        Random random = new Random(12345L);
        System.out.println("loading rasters");
        RasterDebug.Rasters rasters = new RasterDebug.Rasters();
        System.out.println();
        int count = 0;
        while (count < 20) {
            GooglePanorama panorama = PanoramaProfileDebug.trySelectPanorama(random, rasters);
            if (panorama == null) continue;
            double latitude = panorama.getLatitude();
            double longitude = panorama.getLongitude();
            int x = MathHelper.func_76128_c((double)((longitude + 180.0) / 360.0 * (double)rasters.elevation.getWidth()));
            int y = MathHelper.func_76128_c((double)((90.0 - latitude) / 180.0 * (double)rasters.elevation.getHeight()));
            System.out.println(count + 1 + ". " + latitude + ", " + longitude);
            System.out.println("  elevation: " + rasters.elevation.get(x, y) + "m");
            System.out.println("  annual rainfall: " + rasters.annualRainfall.get(x, y) + "mm");
            System.out.println("  min temperature: " + rasters.minTemperature.get(x, y) + "C");
            System.out.println("  mean temperature: " + rasters.meanTemperature.get(x, y) + "C");
            System.out.println("  cover class: " + rasters.cover.get(x, y));
            System.out.println("  soil suborder: " + (Object)((Object)rasters.soil.get(x, y)));
            System.out.println("  soil order: " + (Object)((Object)rasters.soil.get((int)x, (int)y).order));
            System.out.println("  organic carbon content: " + rasters.occ.get(x, y) + " g/kg");
            System.out.println("  cation exchange capacity: " + rasters.cec.get(x, y) + " cmolc/kg");
            System.out.println("  pH: " + (double)rasters.ph.get(x, y) / 10.0);
            System.out.println("  clay content: " + rasters.clay.get(x, y) + "%");
            System.out.println("  silt content: " + rasters.silt.get(x, y) + "%");
            System.out.println("  sand content: " + rasters.sand.get(x, y) + "%");
            System.out.println();
            ++count;
        }
    }

    @Nullable
    private static GooglePanorama trySelectPanorama(Random random, RasterDebug.Rasters rasters) throws IOException {
        int y;
        double latitude = random.nextDouble() * 180.0 - 90.0;
        double longitude = random.nextDouble() * 360.0 - 180.0;
        int x = MathHelper.func_76128_c((double)((longitude + 180.0) / 360.0 * (double)rasters.elevation.getWidth()));
        float elevation = rasters.elevation.get(x, y = MathHelper.func_76128_c((double)((90.0 - latitude) / 180.0 * (double)rasters.elevation.getHeight())));
        if (elevation <= 50.0f) {
            return null;
        }
        return GooglePanorama.lookup(latitude, longitude, 50000.0);
    }
}

