/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.util.debug;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.imageio.ImageIO;
import net.gegy1000.earth.server.integration.bop.BoPTrees;
import net.gegy1000.earth.server.shared.SharedEarthData;
import net.gegy1000.earth.server.util.debug.BiomeColors;
import net.gegy1000.earth.server.util.debug.CoverColors;
import net.gegy1000.earth.server.util.debug.DebugBootstrap;
import net.gegy1000.earth.server.util.debug.SoilColors;
import net.gegy1000.earth.server.util.zoom.Zoomable;
import net.gegy1000.earth.server.world.EarthDataInitializer;
import net.gegy1000.earth.server.world.biome.BiomeClassifier;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.cover.CoverMarkers;
import net.gegy1000.earth.server.world.data.source.StdSource;
import net.gegy1000.earth.server.world.data.source.WorldClimateRaster;
import net.gegy1000.earth.server.world.ecology.GrowthIndicator;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.soil.SoilSuborder;
import net.gegy1000.earth.server.world.ecology.vegetation.Trees;
import net.gegy1000.earth.server.world.geography.Landform;
import net.gegy1000.terrarium.server.util.Vec2i;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.gegy1000.terrarium.server.world.data.raster.FloatRaster;
import net.gegy1000.terrarium.server.world.data.raster.Raster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;
import net.minecraft.world.biome.Biome;

final class RasterDebug {
    private static final int TILE_SIZE = 1000;
    private static final Path OUTPUT = Paths.get("mods/terrarium/debug", new String[0]);
    private static final Vegetation[] TREES = new Vegetation[]{new Vegetation(Trees.Indicators.ACACIA, new Color(255, 184, 63)), new Vegetation(Trees.Indicators.BIRCH, new Color(143, 255, 180)), new Vegetation(Trees.Indicators.JUNGLE_LIKE, new Color(42, 175, 0)), new Vegetation(Trees.Indicators.OAK, new Color(78, 145, 77)), new Vegetation(Trees.Indicators.PINE, new Color(40, 118, 79)), new Vegetation(Trees.Indicators.SPRUCE, new Color(36, 99, 64)), new Vegetation(BoPTrees.Indicators.EBONY, new Color(87, 62, 58)), new Vegetation(BoPTrees.Indicators.FIR, new Color(44, 116, 109)), new Vegetation(BoPTrees.Indicators.MAHOGANY, new Color(116, 76, 80)), new Vegetation(BoPTrees.Indicators.PALM, new Color(141, 199, 50)), new Vegetation(BoPTrees.Indicators.EUCALYPTUS, new Color(255, 111, 0)), new Vegetation(BoPTrees.Indicators.MANGROVE, new Color(78, 199, 183)), new Vegetation(BoPTrees.Indicators.WILLOW, new Color(32, 84, 84))};

    RasterDebug() {
    }

    public static void main(String[] args) throws IOException {
        Files.createDirectories(OUTPUT, new FileAttribute[0]);
        DebugBootstrap.run();
        System.out.println("loading rasters");
        Rasters rasters = new Rasters();
        System.out.println("rendering soil suborder masks");
        RasterDebug.renderSoilMasks(rasters);
        System.out.println("rendering merged soils");
        RasterDebug.renderEnumRaster("global_soil", rasters.soil, SoilColors::get);
        System.out.println("rendering merged cover");
        RasterDebug.renderEnumRaster("global_cover", rasters.cover, CoverColors::get);
        System.out.println("rendering dominant tree layer");
        RasterDebug.renderDominantTrees(rasters);
        System.out.println("rendering biome layer");
        RasterDebug.renderBiomes(rasters);
    }

    private static <E extends Enum<E>> void renderEnumRaster(String name, EnumRaster<E> raster, ToIntFunction<E> color) throws IOException {
        Path path = OUTPUT.resolve(name + ".png");
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        BufferedImage maskImage = new BufferedImage(raster.getWidth(), raster.getHeight(), 1);
        raster.iterate((value, x, y) -> maskImage.setRGB(x, y, color.applyAsInt(value)));
        ImageIO.write((RenderedImage)maskImage, "png", path.toFile());
    }

    private static void renderSoilMasks(Rasters rasters) throws IOException {
        int width = rasters.soil.getWidth();
        int height = rasters.soil.getHeight();
        for (SoilSuborder maskClass : SoilSuborder.values()) {
            Path path = OUTPUT.resolve(maskClass.name().toLowerCase(Locale.ROOT) + ".png");
            if (Files.exists(path, new LinkOption[0])) continue;
            BufferedImage maskImage = new BufferedImage(width, height, 1);
            rasters.soil.iterate((value, x, y) -> {
                if (value == maskClass) {
                    maskImage.setRGB(x, y, 0xFF0000);
                } else {
                    Cover cover = rasters.cover.get(x, y);
                    maskImage.setRGB(x, y, cover == Cover.WATER ? 255 : 0);
                }
            });
            ImageIO.write((RenderedImage)maskImage, "png", path.toFile());
        }
    }

    private static void renderDominantTrees(Rasters rasters) throws IOException {
        int width = rasters.elevation.getWidth();
        int height = rasters.elevation.getHeight();
        BufferedImage dominantTreeImage = new BufferedImage(width, height, 1);
        GrowthPredictors predictors = new GrowthPredictors();
        rasters.elevation.iterate((elevation, x, y) -> {
            if (elevation >= 0.0f) {
                rasters.samplePredictorsTo(predictors, x, y);
                double dominantIndicator = 0.0;
                Vegetation domininantTree = null;
                for (Vegetation tree : TREES) {
                    double indicator = tree.indicator.evaluate(predictors);
                    if (!(indicator > dominantIndicator)) continue;
                    dominantIndicator = indicator;
                    domininantTree = tree;
                }
                if (domininantTree != null) {
                    dominantTreeImage.setRGB(x, y, domininantTree.color.getRGB());
                }
            } else {
                dominantTreeImage.setRGB(x, y, 255);
            }
        });
        ImageIO.write((RenderedImage)dominantTreeImage, "png", OUTPUT.resolve("global_dominant_tree.png").toFile());
    }

    private static void renderBiomes(Rasters rasters) throws IOException {
        int width = rasters.elevation.getWidth();
        int height = rasters.elevation.getHeight();
        BufferedImage biomeImage = new BufferedImage(width, height, 1);
        GrowthPredictors predictors = new GrowthPredictors();
        rasters.elevation.iterate((elevation, x, y) -> {
            rasters.samplePredictorsTo(predictors, x, y);
            Biome biome = BiomeClassifier.classify(predictors);
            biomeImage.setRGB(x, y, BiomeColors.get(biome));
        });
        ImageIO.write((RenderedImage)biomeImage, "png", OUTPUT.resolve("global_biomes.png").toFile());
    }

    private static FloatRaster sampleMinTemperature(WorldClimateRaster source) {
        FloatRaster dst = FloatRaster.create(DataView.rect(2000, 1000));
        dst.transform((value, x, y) -> {
            int climateX = x * source.getWidth() / dst.getWidth();
            int climateY = y * source.getHeight() / dst.getHeight();
            return source.getMinTemperature(climateX, climateY);
        });
        return dst;
    }

    private static FloatRaster sampleMeanTemperature(WorldClimateRaster source) {
        FloatRaster dst = FloatRaster.create(DataView.rect(2000, 1000));
        dst.transform((value, x, y) -> {
            int climateX = x * source.getWidth() / dst.getWidth();
            int climateY = y * source.getHeight() / dst.getHeight();
            return source.getMeanTemperature(climateX, climateY);
        });
        return dst;
    }

    private static ShortRaster sampleAnnualRainfall(WorldClimateRaster source) {
        ShortRaster dst = ShortRaster.create(DataView.rect(2000, 1000));
        dst.transform((value, x, y) -> {
            int climateX = x * source.getWidth() / dst.getWidth();
            int climateY = y * source.getHeight() / dst.getHeight();
            return source.getAnnualRainfall(climateX, climateY);
        });
        return dst;
    }

    static <R extends Raster<?>> R sampleGlobal(Zoomable<StdSource<R>> source, Function<DataView, R> createRaster) throws IOException {
        Raster global = (Raster)createRaster.apply(DataView.rect(2000, 1000));
        for (int x = 0; x < 2; ++x) {
            DataView srcView = DataView.square(x * 1000, 0, 1000);
            source.forZoom(0).load(new Vec2i(x, 0)).ifPresent(tile -> Raster.rasterCopy(tile, srcView, global, global.asView()));
        }
        return (R)global;
    }

    static class Vegetation {
        private final GrowthIndicator indicator;
        private final Color color;

        Vegetation(GrowthIndicator indicator, Color color) {
            this.indicator = indicator;
            this.color = color;
        }
    }

    static class Rasters {
        final FloatRaster elevation = RasterDebug.sampleGlobal(EarthDataInitializer.ELEVATION_SOURCE, FloatRaster::create);
        final EnumRaster<Cover> cover = RasterDebug.sampleGlobal(EarthDataInitializer.LAND_COVER_SOURCE, view -> EnumRaster.create(Cover.NO, view));
        final EnumRaster<SoilSuborder> soil = RasterDebug.sampleGlobal(EarthDataInitializer.SOIL_CLASS_SOURCE, view -> EnumRaster.create(SoilSuborder.NO, view));
        final ShortRaster cec = RasterDebug.sampleGlobal(EarthDataInitializer.CATION_EXCHANGE_CAPACITY_SOURCE, ShortRaster::create);
        final ShortRaster occ = RasterDebug.sampleGlobal(EarthDataInitializer.ORGANIC_CARBON_CONTENT_SOURCE, ShortRaster::create);
        final UByteRaster ph = RasterDebug.sampleGlobal(EarthDataInitializer.PH_SOURCE, UByteRaster::create);
        final UByteRaster clay = RasterDebug.sampleGlobal(EarthDataInitializer.CLAY_CONTENT_SOURCE, UByteRaster::create);
        final UByteRaster silt = RasterDebug.sampleGlobal(EarthDataInitializer.SILT_CONTENT_SOURCE, UByteRaster::create);
        final UByteRaster sand = RasterDebug.sampleGlobal(EarthDataInitializer.SAND_CONTENT_SOURCE, UByteRaster::create);
        final ShortRaster annualRainfall;
        final FloatRaster minTemperature;
        final FloatRaster meanTemperature;

        Rasters() throws IOException {
            WorldClimateRaster climateRaster = SharedEarthData.instance().get(SharedEarthData.CLIMATIC_VARIABLES);
            if (climateRaster == null) {
                throw new IllegalStateException();
            }
            this.annualRainfall = RasterDebug.sampleAnnualRainfall(climateRaster);
            this.minTemperature = RasterDebug.sampleMinTemperature(climateRaster);
            this.meanTemperature = RasterDebug.sampleMeanTemperature(climateRaster);
        }

        void samplePredictorsTo(GrowthPredictors predictors, int x, int y) {
            predictors.elevation = this.elevation.get(x, y);
            predictors.annualRainfall = this.annualRainfall.get(x, y);
            predictors.minTemperature = this.minTemperature.get(x, y);
            predictors.meanTemperature = this.meanTemperature.get(x, y);
            predictors.cationExchangeCapacity = this.cec.get(x, y);
            predictors.organicCarbonContent = this.occ.get(x, y);
            predictors.pH = this.ph.get(x, y);
            predictors.clayContent = this.clay.get(x, y);
            predictors.siltContent = this.silt.get(x, y);
            predictors.sandContent = this.sand.get(x, y);
            predictors.slope = 0;
            predictors.cover = this.cover.get(x, y);
            predictors.soilSuborder = this.soil.get(x, y);
            Landform landform = predictors.landform = predictors.elevation <= 0.0f ? Landform.SEA : Landform.LAND;
            if (predictors.landform.isLand() && predictors.cover.is(CoverMarkers.WATER)) {
                predictors.landform = Landform.LAKE_OR_RIVER;
            }
        }
    }
}

