/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world;

import java.util.function.Function;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.ecology.soil.SoilSuborder;
import net.gegy1000.earth.server.world.geography.Landform;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.gegy1000.terrarium.server.world.data.raster.FloatRaster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;
import net.minecraft.util.ResourceLocation;

public final class EarthData {
    public static final DataKey<ShortRaster> TERRAIN_HEIGHT = EarthData.create("terrain_height", ShortRaster::create);
    public static final DataKey<UByteRaster> SLOPE = EarthData.create("slope", UByteRaster::create);
    public static final DataKey<EnumRaster<Cover>> COVER = EarthData.create("cover", view -> EnumRaster.create(Cover.NO, view));
    public static final DataKey<EnumRaster<Landform>> LANDFORM = EarthData.create("landform", view -> EnumRaster.create(Landform.LAND, view));
    public static final DataKey<ShortRaster> WATER_LEVEL = EarthData.create("water", ShortRaster::create);
    public static final DataKey<FloatRaster> ELEVATION_METERS = EarthData.create("elevation_meters", FloatRaster::create);
    public static final DataKey<FloatRaster> MIN_TEMPERATURE = EarthData.create("min_temperature", view -> FloatRaster.create(view, 10.0f));
    public static final DataKey<FloatRaster> MEAN_TEMPERATURE = EarthData.create("mean_temperature", view -> FloatRaster.create(view, 14.0f));
    public static final DataKey<ShortRaster> ANNUAL_RAINFALL = EarthData.create("annual_rainfall", view -> ShortRaster.create(view, 300));
    public static final DataKey<UByteRaster> CATION_EXCHANGE_CAPACITY = EarthData.create("cation_exchange_capacity", view -> UByteRaster.create(view, 10));
    public static final DataKey<ShortRaster> ORGANIC_CARBON_CONTENT = EarthData.create("organic_carbon_content", view -> ShortRaster.create(view, 10));
    public static final DataKey<UByteRaster> SOIL_PH = EarthData.create("soil_ph", view -> UByteRaster.create(view, 70));
    public static final DataKey<UByteRaster> CLAY_CONTENT = EarthData.create("clay_content", view -> UByteRaster.create(view, 33));
    public static final DataKey<UByteRaster> SILT_CONTENT = EarthData.create("silt_content", view -> UByteRaster.create(view, 33));
    public static final DataKey<UByteRaster> SAND_CONTENT = EarthData.create("sand_content", view -> UByteRaster.create(view, 33));
    public static final DataKey<EnumRaster<SoilSuborder>> SOIL_SUBORDER = EarthData.create("soil_class", view -> EnumRaster.create(SoilSuborder.NO, view));

    private static <T> DataKey<T> create(String name, Function<DataView, T> createDefault) {
        return DataKey.create(new ResourceLocation("earth", name), createDefault);
    }
}

