/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world;

import com.google.gson.JsonElement;
import java.util.Map;
import java.util.function.Consumer;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.gegy1000.terrarium.server.world.generator.customization.PropertySchema;
import net.gegy1000.terrarium.server.world.generator.customization.property.PropertyKey;
import net.gegy1000.terrarium.server.world.generator.customization.property.PropertyPair;

public final class EarthPropertySchema
implements PropertySchema {
    public static final EarthPropertySchema INSTANCE = new EarthPropertySchema();

    private EarthPropertySchema() {
    }

    @Override
    public boolean parse(Map<String, JsonElement> entries, Consumer<PropertyPair<?>> consumer) {
        int version = this.detectVersion(entries);
        if (version == 0) {
            return this.parseLegacy(entries, consumer);
        }
        return this.parseLatest(entries, consumer);
    }

    private int detectVersion(Map<String, JsonElement> entries) {
        if (this.matchesLegacy(entries)) {
            return 0;
        }
        return 1;
    }

    private boolean matchesLegacy(Map<String, JsonElement> entries) {
        for (PropertyKey<?> legacy : EarthProperties.Legacy.PROPERTIES) {
            if (entries.containsKey(legacy.getIdentifier())) continue;
            return false;
        }
        return true;
    }

    private boolean parseLatest(Map<String, JsonElement> entries, Consumer<PropertyPair<?>> consumer) {
        return EarthProperties.SCHEMA.parse(entries, consumer);
    }

    private boolean parseLegacy(Map<String, JsonElement> entries, Consumer<PropertyPair<?>> consumer) {
        GenerationSettings.Builder legacyBuilder = GenerationSettings.builder();
        if (EarthProperties.Legacy.SCHEMA.parse(entries, legacyBuilder::put)) {
            GenerationSettings legacy = legacyBuilder.build();
            double spawnLatitude = legacy.getDouble(EarthProperties.Legacy.SPAWN_LATITUDE);
            double spawnLongitude = legacy.getDouble(EarthProperties.Legacy.SPAWN_LONGITUDE);
            consumer.accept(PropertyPair.of(EarthProperties.SPAWN_LATITUDE, spawnLatitude));
            consumer.accept(PropertyPair.of(EarthProperties.SPAWN_LONGITUDE, spawnLongitude));
            double worldScale = 1.0 / legacy.getDouble(EarthProperties.Legacy.WORLD_SCALE);
            double heightScale = legacy.getDouble(EarthProperties.Legacy.HEIGHT_SCALE);
            int heightOrigin = legacy.getInteger(EarthProperties.Legacy.HEIGHT_ORIGIN);
            consumer.accept(PropertyPair.of(EarthProperties.WORLD_SCALE, worldScale));
            consumer.accept(PropertyPair.of(EarthProperties.TERRESTRIAL_HEIGHT_SCALE, heightScale));
            consumer.accept(PropertyPair.of(EarthProperties.OCEANIC_HEIGHT_SCALE, heightScale));
            consumer.accept(PropertyPair.of(EarthProperties.HEIGHT_OFFSET, heightOrigin));
            boolean decoration = legacy.getBoolean(EarthProperties.Legacy.ENABLE_DECORATION);
            consumer.accept(PropertyPair.of(EarthProperties.ADD_TREES, decoration));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_GRASS, decoration));
            boolean defaultDecoration = legacy.getBoolean(EarthProperties.Legacy.ENABLE_DEFAULT_DECORATION);
            consumer.accept(PropertyPair.of(EarthProperties.ADD_FLOWERS, defaultDecoration));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_CACTI, defaultDecoration));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_SUGAR_CANE, defaultDecoration));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_GOURDS, defaultDecoration));
            boolean defaultFeatures = legacy.getBoolean(EarthProperties.Legacy.ENABLE_DEFAULT_FEATURES);
            consumer.accept(PropertyPair.of(EarthProperties.ADD_STRONGHOLDS, defaultFeatures));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_VILLAGES, defaultFeatures));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_MINESHAFTS, defaultFeatures));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_TEMPLES, defaultFeatures));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_OCEAN_MONUMENTS, defaultFeatures));
            consumer.accept(PropertyPair.of(EarthProperties.ADD_WOODLAND_MANSIONS, defaultFeatures));
            boolean caveGeneration = legacy.getBoolean(EarthProperties.Legacy.ENABLE_CAVE_GENERATION);
            consumer.accept(PropertyPair.of(EarthProperties.CAVE_GENERATION, caveGeneration));
            consumer.accept(PropertyPair.of(EarthProperties.RAVINE_GENERATION, caveGeneration));
            boolean resourceGeneration = legacy.getBoolean(EarthProperties.Legacy.ENABLE_RESOURCE_GENERATION);
            consumer.accept(PropertyPair.of(EarthProperties.ORE_GENERATION, resourceGeneration));
            boolean modGeneration = legacy.getBoolean(EarthProperties.Legacy.ENABLE_MOD_GENERATION);
            consumer.accept(PropertyPair.of(EarthProperties.COMPATIBILITY_MODE, modGeneration));
            consumer.accept(PropertyPair.of(EarthProperties.BOP_INTEGRATION, false));
            return true;
        }
        TerrariumEarth.LOGGER.warn("Failed to parse legacy schema!");
        return false;
    }
}

