/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.client.PrepareTerrarium;
import net.gegy1000.earth.client.gui.EarthCustomizationGui;
import net.gegy1000.earth.server.capability.EarthWorld;
import net.gegy1000.earth.server.shared.SharedEarthData;
import net.gegy1000.earth.server.world.EarthDataInitializer;
import net.gegy1000.earth.server.world.EarthGenerationInitializer;
import net.gegy1000.earth.server.world.EarthInitContext;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.earth.server.world.EarthPropertySchema;
import net.gegy1000.terrarium.client.gui.customization.SelectPresetGui;
import net.gegy1000.terrarium.server.TerrariumUserTracker;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.TerrariumDataInitializer;
import net.gegy1000.terrarium.server.world.TerrariumGeneratorInitializer;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.gegy1000.terrarium.server.world.chunk.ComposableChunkGenerator;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.gegy1000.terrarium.server.world.generator.customization.PropertySchema;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumCustomization;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumPreset;
import net.gegy1000.terrarium.server.world.generator.customization.widget.SliderScale;
import net.gegy1000.terrarium.server.world.generator.customization.widget.SliderWidget;
import net.gegy1000.terrarium.server.world.generator.customization.widget.ToggleWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EarthWorldType
extends TerrariumWorldType {
    public static final double CLIMATE_SCALE = 9276.624305555555;
    private static final ResourceLocation IDENTIFIER = new ResourceLocation("earth", "earth");
    private static final ResourceLocation PRESET = new ResourceLocation("earth", "scenic");

    public EarthWorldType() {
        super("earth", IDENTIFIER, PRESET);
    }

    @Override
    public ComposableChunkGenerator createGenerator(World world) {
        return new ComposableChunkGenerator(world);
    }

    @Override
    public TerrariumGeneratorInitializer createGeneratorInitializer(World world, GenerationSettings settings, ColumnDataCache dataCache) {
        world.func_181544_b(settings.getInteger(EarthProperties.HEIGHT_OFFSET) + 2);
        return new EarthGenerationInitializer(EarthInitContext.from(settings), world, dataCache);
    }

    @Override
    public TerrariumDataInitializer createDataInitializer(GenerationSettings settings) {
        return new EarthDataInitializer(EarthInitContext.from(settings));
    }

    @Override
    public Collection<ICapabilityProvider> createCapabilities(World world, GenerationSettings settings) {
        return Lists.newArrayList((Object[])new ICapabilityProvider[]{new EarthWorld.Impl(settings)});
    }

    @Override
    public PropertySchema buildPropertySchema() {
        return EarthPropertySchema.INSTANCE;
    }

    @Override
    public TerrariumCustomization buildCustomization() {
        return TerrariumCustomization.builder().withCategory("world", new SliderWidget(EarthProperties.WORLD_SCALE).range(1.0, 40000.0).step(5.0, 1.0).scale(SliderScale.power(3.0)).display(value -> {
            if (value < 1000.0) {
                return String.format("1:%.0fm", value);
            }
            return String.format("1:%.1fkm", value / 1000.0);
        }), new SliderWidget(EarthProperties.TERRESTRIAL_HEIGHT_SCALE).range(0.0, 50.0).step(0.5, 0.1).scale(SliderScale.power(3.0)).display(value -> String.format("%.1fx", value)), new SliderWidget(EarthProperties.OCEANIC_HEIGHT_SCALE).range(0.0, 50.0).step(0.5, 0.1).scale(SliderScale.power(3.0)).display(value -> String.format("%.1fx", value)), new SliderWidget(EarthProperties.HEIGHT_OFFSET).range(-63.0, 128.0).display(value -> String.format("%.0f blocks", value))).withCategory("ecological", new ToggleWidget(EarthProperties.ADD_TREES), new ToggleWidget(EarthProperties.ADD_GRASS), new ToggleWidget(EarthProperties.ADD_FLOWERS), new ToggleWidget(EarthProperties.ADD_CACTI), new ToggleWidget(EarthProperties.ADD_SUGAR_CANE), new ToggleWidget(EarthProperties.ADD_GOURDS)).withCategory("geological", new ToggleWidget(EarthProperties.CAVE_GENERATION), new ToggleWidget(EarthProperties.RAVINE_GENERATION), new ToggleWidget(EarthProperties.ORE_GENERATION)).withCategory("structure", new ToggleWidget(EarthProperties.ADD_STRONGHOLDS), new ToggleWidget(EarthProperties.ADD_VILLAGES), new ToggleWidget(EarthProperties.ADD_MINESHAFTS), new ToggleWidget(EarthProperties.ADD_TEMPLES), new ToggleWidget(EarthProperties.ADD_OCEAN_MONUMENTS), new ToggleWidget(EarthProperties.ADD_WOODLAND_MANSIONS)).withCategory("compatibility", new ToggleWidget(EarthProperties.COMPATIBILITY_MODE), new ToggleWidget(EarthProperties.BOP_INTEGRATION).locked(!TerrariumEarth.hasBiomesOPlenty)).build();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCustomize(Minecraft client, WorldType worldType, GuiCreateWorld parent) {
        if (!SharedEarthData.isInitialized()) {
            client.func_147108_a(PrepareTerrarium.prepareScreen((GuiScreen)parent, () -> this.onCustomize(client, worldType, parent)));
            return;
        }
        EarthCustomizationGui customizationGui = new EarthCustomizationGui(parent, this);
        if (Strings.isNullOrEmpty((String)parent.field_146334_a)) {
            Consumer<TerrariumPreset> acceptPreset = preset -> {
                customizationGui.applyPreset((TerrariumPreset)preset);
                client.func_147108_a((GuiScreen)customizationGui);
            };
            client.func_147108_a((GuiScreen)new SelectPresetGui(acceptPreset, (GuiScreen)parent, this));
        } else {
            client.func_147108_a((GuiScreen)customizationGui);
        }
    }

    @Override
    public boolean shouldReduceSlimes(World world, Random random) {
        TerrariumWorld terrarium = TerrariumWorld.get(world);
        if (terrarium == null) {
            return false;
        }
        return terrarium.getSettings().getInteger(EarthProperties.HEIGHT_OFFSET) < 40;
    }

    @Override
    public double getHorizon(World world) {
        GenerationSettings settings = TerrariumUserTracker.getProvidedSettings();
        if (settings == null) {
            return 63.0;
        }
        return settings.getInteger(EarthProperties.HEIGHT_OFFSET);
    }

    @Override
    public float getCloudHeight() {
        GenerationSettings settings = TerrariumUserTracker.getProvidedSettings();
        if (settings == null) {
            return 128.0f;
        }
        double cloudHeight = this.transformHeight(settings, 2000.0);
        return (float)Math.max(cloudHeight, settings.getDouble(EarthProperties.HEIGHT_OFFSET) + 64.0);
    }

    @Override
    protected int getMinGenerationHeight(WorldServer world, GenerationSettings settings) {
        double height = this.transformHeight(settings, -11100.0);
        return MathHelper.func_76128_c((double)height) - 1;
    }

    @Override
    protected int getMaxGenerationHeight(WorldServer world, GenerationSettings settings) {
        double height = this.transformHeight(settings, 8900.0);
        return MathHelper.func_76143_f((double)height) + 1;
    }

    private double transformHeight(GenerationSettings settings, double height) {
        double heightScale = height >= 0.0 ? settings.getDouble(EarthProperties.TERRESTRIAL_HEIGHT_SCALE) : settings.getDouble(EarthProperties.OCEANIC_HEIGHT_SCALE);
        double scale = heightScale / settings.getDouble(EarthProperties.WORLD_SCALE);
        double offset = settings.getDouble(EarthProperties.HEIGHT_OFFSET);
        return height * scale + offset;
    }
}

