/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.biome;

import net.gegy1000.earth.server.world.Climate;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.cover.CoverMarkers;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.soil.SoilSelector;
import net.gegy1000.earth.server.world.ecology.vegetation.Trees;
import net.gegy1000.earth.server.world.geography.Landform;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public final class BiomeClassifier {
    public static Biome classify(GrowthPredictors predictors) {
        if (predictors.elevation == -3.4028235E38f) {
            return Biomes.field_185440_P;
        }
        if (predictors.isLand()) {
            return BiomeClassifier.classifyLand(predictors);
        }
        return BiomeClassifier.classifyWater(predictors);
    }

    private static Biome classifyLand(GrowthPredictors predictors) {
        if (predictors.landform == Landform.BEACH) {
            return predictors.isFrozen() ? Biomes.field_150577_O : Biomes.field_76787_r;
        }
        if (predictors.isFrozen()) {
            return BiomeClassifier.classifyFrozen(predictors);
        }
        if (predictors.isFlooded()) {
            return BiomeClassifier.classifyFlooded(predictors);
        }
        float annualRainfall = predictors.annualRainfall;
        float meanTemperature = predictors.meanTemperature;
        if (Climate.isDesert(annualRainfall) && SoilSelector.isDesertLike(predictors)) {
            return Biomes.field_76769_d;
        }
        if (!predictors.isBarren()) {
            if (Climate.isTropicalRainforest(annualRainfall, meanTemperature)) {
                return predictors.isForested() ? Biomes.field_76782_w : Biomes.field_150574_L;
            }
            if (Climate.isTaiga(annualRainfall, meanTemperature) && predictors.isForested()) {
                return Biomes.field_76768_g;
            }
        }
        if (Climate.isCold(meanTemperature)) {
            return Biomes.field_76768_g;
        }
        if (Climate.isDry(annualRainfall)) {
            return Biomes.field_150588_X;
        }
        return predictors.isForested() ? BiomeClassifier.classifyForest(predictors) : Biomes.field_76772_c;
    }

    private static Biome classifyFrozen(GrowthPredictors predictors) {
        return predictors.isForested() ? Biomes.field_150584_S : Biomes.field_76774_n;
    }

    private static Biome classifyFlooded(GrowthPredictors predictors) {
        if (predictors.cover == Cover.SALINE_FLOODED_FOREST) {
            return Biomes.field_76780_h;
        }
        return predictors.isForested() ? Biomes.field_76782_w : Biomes.field_150574_L;
    }

    private static Biome classifyForest(GrowthPredictors predictors) {
        double birch;
        double oak = Trees.Indicators.OAK.evaluate(predictors);
        if (oak > (birch = (double)Trees.Indicators.BIRCH.evaluate(predictors)) && predictors.cover.is(CoverMarkers.CLOSED_FOREST)) {
            return Biomes.field_150585_R;
        }
        return oak > birch ? Biomes.field_76767_f : Biomes.field_150583_P;
    }

    private static Biome classifyWater(GrowthPredictors predictors) {
        if (predictors.isSea()) {
            if (predictors.elevation < -500.0f) {
                return Biomes.field_150575_M;
            }
            return Biomes.field_76771_b;
        }
        return predictors.isFrozen() ? Biomes.field_76777_m : Biomes.field_76781_i;
    }
}

