/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.compatibility;

import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.gegy1000.earth.server.world.compatibility.ModGeneratorCompatibility;
import net.gegy1000.terrarium.Terrarium;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class ColumnCompatibilityWorld
extends World
implements AutoCloseable {
    private static final WorldGenerator NOOP_GENERATOR = new WorldGenerator(){

        public boolean func_180709_b(World world, Random rand, BlockPos position) {
            return false;
        }
    };
    private final World parent;
    private final IChunkGenerator generator;
    private ChunkPos columnPos;
    private BlockPos columnDecoratePos;
    private int minY;
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public ColumnCompatibilityWorld(World parent) {
        super(parent.func_72860_G(), parent.func_72912_H(), parent.field_73011_w, parent.field_72984_F, parent.field_72995_K);
        this.parent = parent;
        this.generator = ColumnCompatibilityWorld.getChunkGenerator(parent);
        this.field_73020_y = this.func_72970_h();
    }

    private static IChunkGenerator getChunkGenerator(World world) {
        IChunkProvider provider = world.func_72863_F();
        if (provider instanceof ChunkProviderServer) {
            return ((ChunkProviderServer)provider).field_186029_c;
        }
        return null;
    }

    public void setupAt(ChunkPos columnPos, int minY) {
        this.getChunkProvider().clear();
        this.columnPos = columnPos;
        this.columnDecoratePos = new BlockPos(this.columnPos.func_180334_c(), 0, this.columnPos.func_180333_d());
        this.minY = minY;
    }

    public int getMinY() {
        return this.minY;
    }

    public boolean fireDecorateEvent(Random random, DecorateBiomeEvent.Decorate.EventType type) {
        return TerrainGen.decorate((World)this, (Random)random, (ChunkPos)this.columnPos, (DecorateBiomeEvent.Decorate.EventType)type);
    }

    public boolean firePopulateEvent(Random random, boolean pre) {
        if (this.generator == null) {
            return false;
        }
        if (pre) {
            return MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(this.generator, (World)this, random, this.columnPos.field_77276_a, this.columnPos.field_77275_b, false));
        }
        return MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(this.generator, (World)this, random, this.columnPos.field_77276_a, this.columnPos.field_77275_b, false));
    }

    public boolean firePopulateEvent(Random random, PopulateChunkEvent.Populate.EventType type) {
        if (this.generator == null) {
            return false;
        }
        return TerrainGen.populate((IChunkGenerator)this.generator, (World)this, (Random)random, (int)this.columnPos.field_77276_a, (int)this.columnPos.field_77275_b, (boolean)false, (PopulateChunkEvent.Populate.EventType)type);
    }

    public boolean fireOreGenEvent(Random random, boolean pre) {
        if (pre) {
            return MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre((World)this, random, this.columnDecoratePos));
        }
        return MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post((World)this, random, this.columnDecoratePos));
    }

    public boolean fireOreGenEvent(Random random, OreGenEvent.GenerateMinable.EventType type) {
        return TerrainGen.generateOre((World)this, (Random)random, (WorldGenerator)NOOP_GENERATOR, (BlockPos)this.columnDecoratePos, (OreGenEvent.GenerateMinable.EventType)type);
    }

    public void runModdedGenerators() {
        if (this.generator == null) {
            return;
        }
        IChunkProvider chunkProvider = this.parent.func_72863_F();
        ModGeneratorCompatibility.runGenerators(this, this.columnPos, this.generator, chunkProvider);
    }

    protected IChunkProvider func_72970_h() {
        return new ChunkProvider();
    }

    public boolean func_175668_a(BlockPos pos, boolean allowEmpty) {
        return this.parent.func_175668_a(pos, allowEmpty);
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        this.mutablePos.func_181079_c(x << 4, this.minY, z << 4);
        return this.parent.func_175668_a((BlockPos)this.mutablePos, allowEmpty);
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        return this.parent.func_180501_a(this.translatePos(pos), newState, flags);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.parent.func_180495_p(this.translatePos(pos));
    }

    public Biome getBiomeForCoordsBody(BlockPos pos) {
        return this.parent.func_180494_b(this.translatePos(pos));
    }

    public int func_189649_b(int x, int z) {
        return this.untranslateY(this.parent.func_189649_b(x, z));
    }

    public int func_72800_K() {
        return this.untranslateY(this.parent.func_72800_K());
    }

    public int func_72940_L() {
        return this.untranslateY(this.parent.func_72940_L());
    }

    public BlockPos func_175725_q(BlockPos pos) {
        BlockPos result = this.parent.func_175725_q(this.translatePos(pos));
        int y = this.untranslateY(result.func_177956_o());
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }

    public BlockPos func_175672_r(BlockPos pos) {
        BlockPos result = this.parent.func_175672_r(this.translatePos(pos));
        int y = this.untranslateY(result.func_177956_o());
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }

    public void func_175653_a(EnumSkyBlock type, BlockPos pos, int lightValue) {
        this.parent.func_175653_a(type, this.translatePos(pos), lightValue);
    }

    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        return this.parent.func_175642_b(type, this.translatePos(pos));
    }

    public float func_175724_o(BlockPos pos) {
        return this.parent.func_175724_o(this.translatePos(pos));
    }

    public int func_181545_F() {
        return this.untranslateY(this.parent.func_181545_F());
    }

    public boolean func_72838_d(Entity entity) {
        this.translateEntity(entity);
        return this.parent.func_72838_d(entity);
    }

    public void func_72923_a(Entity entity) {
        this.translateEntity(entity);
        this.parent.func_72923_a(entity);
    }

    public void func_72847_b(Entity entity) {
        this.parent.func_72847_b(entity);
    }

    public void func_72954_a(IWorldEventListener listener) {
        this.parent.func_72954_a(listener);
        super.func_72954_a(listener);
    }

    public void func_72848_b(IWorldEventListener listener) {
        this.parent.func_72848_b(listener);
        super.func_72848_b(listener);
    }

    public List<AxisAlignedBB> func_184144_a(@Nullable Entity entity, AxisAlignedBB aabb) {
        aabb = aabb.func_72317_d(0.0, (double)this.minY, 0.0);
        return this.parent.func_184144_a(entity, aabb);
    }

    public ChunkProvider getChunkProvider() {
        return (ChunkProvider)super.func_72863_F();
    }

    @Nullable
    public MinecraftServer func_73046_m() {
        return this.parent.func_73046_m();
    }

    public VillageCollection func_175714_ae() {
        return this.parent.func_175714_ae();
    }

    public BiomeProvider func_72959_q() {
        return this.parent.func_72959_q();
    }

    public BlockPos func_175694_M() {
        return this.parent.func_175694_M();
    }

    public EnumDifficulty func_175659_aa() {
        return this.parent.func_175659_aa();
    }

    public GameRules func_82736_K() {
        return this.parent.func_82736_K();
    }

    public LootTableManager func_184146_ak() {
        return this.parent.func_184146_ak();
    }

    public ISaveHandler func_72860_G() {
        return this.parent.func_72860_G();
    }

    @Nullable
    public MapStorage func_175693_T() {
        return this.parent.func_175693_T();
    }

    public MapStorage getPerWorldStorage() {
        return this.parent.getPerWorldStorage();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.parent.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)this.parent.getCapability(capability, facing);
    }

    @Override
    public void close() {
        this.getChunkProvider().clear();
    }

    private BlockPos translatePos(BlockPos pos) {
        this.mutablePos.func_189533_g((Vec3i)pos);
        this.mutablePos.func_185336_p(pos.func_177956_o() + this.minY);
        return this.mutablePos;
    }

    private int untranslateY(int y) {
        return MathHelper.func_76125_a((int)(y - this.minY), (int)0, (int)255);
    }

    private void translateEntity(Entity entity) {
        if (entity.field_70170_p != this.parent) {
            entity.func_70029_a(this.parent);
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + (double)this.minY, entity.field_70161_v);
        }
    }

    class OffsetChunk
    extends Chunk {
        private final Chunk parent;

        OffsetChunk(Chunk parent) {
            super(parent.func_177412_p(), parent.field_76635_g, parent.field_76647_h);
            this.parent = parent;
        }

        protected void func_186034_a(IChunkGenerator generator) {
        }

        public void func_186030_a(IChunkProvider chunkProvider, IChunkGenerator chunkGenrator) {
        }

        protected void func_76590_a() {
        }

        public void func_76603_b() {
        }

        public void func_150809_p() {
        }

        public void func_76594_o() {
        }

        public void func_76613_n() {
        }

        public void func_150804_b(boolean skipRecheckGaps) {
        }

        public void func_76602_a(ExtendedBlockStorage[] newStorageArrays) {
            Terrarium.LOGGER.warn("Unsupported setStorageArrays on compatibility chunk");
        }

        public void func_76616_a(byte[] biomeArray) {
            Terrarium.LOGGER.warn("Unsupported setBiomeArray on compatibility chunk");
        }

        public void func_177420_a(int[] newHeightMap) {
            Terrarium.LOGGER.warn("Unsupported setHeightMap on compatibility chunk");
        }

        @Nullable
        public IBlockState func_177436_a(BlockPos pos, IBlockState state) {
            return this.parent.func_177436_a(ColumnCompatibilityWorld.this.translatePos(pos), state);
        }

        public IBlockState func_186032_a(int x, int y, int z) {
            return this.parent.func_186032_a(x, y + ColumnCompatibilityWorld.this.minY, z);
        }

        @Nullable
        public TileEntity func_177424_a(BlockPos pos, Chunk.EnumCreateEntityType mode) {
            return this.parent.func_177424_a(ColumnCompatibilityWorld.this.translatePos(pos), mode);
        }

        public void func_150813_a(TileEntity tileEntity) {
            tileEntity.func_174878_a(ColumnCompatibilityWorld.this.translatePos(tileEntity.func_174877_v()).func_185334_h());
            this.parent.func_150813_a(tileEntity);
        }

        public void func_177426_a(BlockPos pos, TileEntity tileEntity) {
            pos = ColumnCompatibilityWorld.this.translatePos(pos).func_185334_h();
            this.parent.func_177426_a(pos, tileEntity);
        }

        public void func_177425_e(BlockPos pos) {
            this.parent.func_177425_e(ColumnCompatibilityWorld.this.translatePos(pos));
        }

        public Map<BlockPos, TileEntity> func_177434_r() {
            return Collections.emptyMap();
        }

        public int func_76611_b(int x, int z) {
            return ColumnCompatibilityWorld.this.untranslateY(this.parent.func_76611_b(x, z));
        }

        public BlockPos func_177440_h(BlockPos pos) {
            BlockPos parent = this.parent.func_177440_h(pos);
            int y = ColumnCompatibilityWorld.this.untranslateY(parent.func_177956_o());
            return new BlockPos(parent.func_177958_n(), y, parent.func_177952_p());
        }

        public boolean func_177444_d(BlockPos pos) {
            return this.parent.func_177444_d(ColumnCompatibilityWorld.this.translatePos(pos));
        }

        public int func_177413_a(EnumSkyBlock type, BlockPos pos) {
            return this.parent.func_177413_a(type, ColumnCompatibilityWorld.this.translatePos(pos));
        }

        public int func_177443_a(BlockPos pos, int amount) {
            return this.parent.func_177443_a(ColumnCompatibilityWorld.this.translatePos(pos), amount);
        }

        public Biome func_177411_a(BlockPos pos, BiomeProvider provider) {
            return this.parent.func_177411_a(ColumnCompatibilityWorld.this.translatePos(pos), provider);
        }

        public byte[] func_76605_m() {
            if (this.parent == null) {
                return super.func_76605_m();
            }
            return this.parent.func_76605_m();
        }

        public void func_76612_a(Entity entity) {
            ColumnCompatibilityWorld.this.translateEntity(entity);
            this.parent.func_76612_a(entity);
        }

        public void func_76622_b(Entity entity) {
            this.parent.func_76622_b(entity);
        }

        public void func_76608_a(Entity entity, int index) {
            if ((index -= MathHelper.func_76128_c((double)((double)ColumnCompatibilityWorld.this.minY / 16.0))) < 0 || index >= 16) {
                return;
            }
            this.parent.func_76608_a(entity, index);
        }

        public <T extends Entity> void func_177430_a(Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, Predicate<? super T> filter) {
            aabb = aabb.func_72317_d(0.0, (double)ColumnCompatibilityWorld.this.minY, 0.0);
            this.parent.func_177430_a(entityClass, aabb, listToFill, filter);
        }

        public void func_177414_a(@Nullable Entity entity, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> filter) {
            aabb = aabb.func_72317_d(0.0, (double)ColumnCompatibilityWorld.this.minY, 0.0);
            this.parent.func_177414_a(entity, aabb, listToFill, filter);
        }

        public boolean func_76621_g() {
            return this.parent.func_76621_g();
        }

        public boolean func_76606_c(int startY, int endY) {
            return this.parent.func_76606_c(startY + ColumnCompatibilityWorld.this.minY, endY + ColumnCompatibilityWorld.this.minY);
        }

        public boolean func_150802_k() {
            return this.parent.func_150802_k();
        }

        public boolean func_177419_t() {
            return this.parent.func_177419_t();
        }

        public boolean func_177423_u() {
            return this.parent.func_177423_u();
        }

        public boolean func_186035_j() {
            return this.parent.func_186035_j();
        }

        public void func_76630_e() {
            this.parent.func_76630_e();
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return this.parent.hasCapability(capability, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)this.parent.getCapability(capability, facing);
        }
    }

    class ChunkProvider
    implements IChunkProvider {
        private final Long2ObjectOpenHashMap<OffsetChunk> chunks = new Long2ObjectOpenHashMap(9);

        ChunkProvider() {
        }

        void clear() {
            this.chunks.clear();
        }

        private OffsetChunk loadChunk(int x, int z) {
            Chunk parentChunk = ColumnCompatibilityWorld.this.parent.func_72964_e(x, z);
            return new OffsetChunk(parentChunk);
        }

        @Nullable
        public Chunk func_186026_b(int x, int z) {
            return (Chunk)this.chunks.get(ChunkPos.func_77272_a((int)x, (int)z));
        }

        public Chunk func_186025_d(int x, int z) {
            Chunk loadedChunk = this.func_186026_b(x, z);
            if (loadedChunk != null) {
                return loadedChunk;
            }
            OffsetChunk chunk = this.loadChunk(x, z);
            this.chunks.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
            return chunk;
        }

        public boolean func_73156_b() {
            return false;
        }

        public boolean func_191062_e(int x, int z) {
            return ColumnCompatibilityWorld.this.parent.func_190526_b(x, z);
        }

        public String func_73148_d() {
            return "ColumnCompatibilityChunkProvider";
        }
    }
}

