/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.compatibility;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.gegy1000.earth.TerrariumEarth;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class ModGenerators {
    private static Set<IWorldGenerator> worldGenerators = new HashSet<IWorldGenerator>();
    private static Field sortedGeneratorListField;
    private static Method computeSortedGeneratorListMethod;

    public static Set<IWorldGenerator> getGenerators() {
        return worldGenerators;
    }

    public static List<IWorldGenerator> getSortedGenerators() {
        if (sortedGeneratorListField == null || computeSortedGeneratorListMethod == null) {
            return Collections.emptyList();
        }
        try {
            if (sortedGeneratorListField.get(null) == null) {
                computeSortedGeneratorListMethod.invoke(null, new Object[0]);
            }
            return (List)sortedGeneratorListField.get(null);
        }
        catch (ReflectiveOperationException e) {
            TerrariumEarth.LOGGER.warn("Failed to get sorted modded world generators", (Throwable)e);
            return Collections.emptyList();
        }
    }

    static {
        try {
            Field field = GameRegistry.class.getDeclaredField("worldGenerators");
            field.setAccessible(true);
            worldGenerators = (Set)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            TerrariumEarth.LOGGER.error("Failed to get worldGenerators field", (Throwable)e);
        }
        try {
            sortedGeneratorListField = GameRegistry.class.getDeclaredField("sortedGeneratorList");
            sortedGeneratorListField.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            TerrariumEarth.LOGGER.error("Failed to find sortedGeneratorList field", (Throwable)e);
        }
        try {
            computeSortedGeneratorListMethod = GameRegistry.class.getDeclaredMethod("computeSortedGeneratorList", new Class[0]);
            computeSortedGeneratorListMethod.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            TerrariumEarth.LOGGER.error("Failed to find computeSortedGeneratorList method", (Throwable)e);
        }
    }
}

