/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.decoration;

import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.gengen.api.CubicPos;
import net.gegy1000.gengen.api.writer.ChunkPopulationWriter;
import net.gegy1000.gengen.util.SpatialRandom;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.composer.decoration.DecorationComposer;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FreezeSurfaceComposer
implements DecorationComposer {
    private static final long SCATTER_SEED = 6193809942152828777L;
    private static final int MAX_SLOPE = 60;
    private final ShortRaster.Sampler heightSampler = ShortRaster.sampler(EarthData.TERRAIN_HEIGHT);
    private final UByteRaster.Sampler slopeSampler = UByteRaster.sampler(EarthData.SLOPE);
    private final SpatialRandom random;

    public FreezeSurfaceComposer(World world) {
        this.random = new SpatialRandom(world, 6193809942152828777L);
    }

    @Override
    public void composeDecoration(TerrariumWorld terrarium, CubicPos pos, ChunkPopulationWriter writer) {
        this.random.setSeed(pos.getX(), pos.getZ());
        World world = writer.getGlobal();
        ColumnDataCache dataCache = terrarium.getDataCache();
        int minX = pos.getCenterX();
        int minZ = pos.getCenterZ();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        DataView view = DataView.square(minX, minZ, 16);
        ShortRaster heightRaster = this.heightSampler.sample(dataCache, view);
        UByteRaster slopeRaster = this.slopeSampler.sample(dataCache, view);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int slope;
                mutablePos.func_181079_c(minX + x + this.random.nextInt(3) - this.random.nextInt(3), 0, minZ + z + this.random.nextInt(3) - this.random.nextInt(3));
                Biome biome = world.func_180494_b((BlockPos)mutablePos);
                float temperature = biome.func_180626_a((BlockPos)mutablePos);
                if (temperature >= 0.15f) continue;
                mutablePos.func_181079_c(minX + x, 0, minZ + z);
                if (!writer.getSurfaceMut(mutablePos)) continue;
                short terrainSurface = heightRaster.get(x, z);
                if (mutablePos.func_177956_o() < terrainSurface) continue;
                BlockPos groundPos = mutablePos.func_177977_b();
                if (this.canBeFrozen(world, groundPos)) {
                    writer.set(groundPos, Blocks.field_150432_aD.func_176223_P());
                }
                if ((slope = slopeRaster.get(x, z)) >= 60 || !this.canBeSnowedOn(world, (BlockPos)mutablePos)) continue;
                writer.set((BlockPos)mutablePos, Blocks.field_150431_aC.func_176223_P());
            }
        }
    }

    private boolean canBeSnowedOn(World world, BlockPos surfacePos) {
        IBlockState surfaceState = world.func_180495_p(surfacePos);
        Block surfaceBlock = surfaceState.func_177230_c();
        return surfaceBlock.isAir(surfaceState, (IBlockAccess)world, surfacePos) && Blocks.field_150431_aC.func_176196_c(world, surfacePos);
    }

    private boolean canBeFrozen(World world, BlockPos groundPos) {
        IBlockState groundState = world.func_180495_p(groundPos);
        Block groundBlock = groundState.func_177230_c();
        return (groundBlock == Blocks.field_150355_j || groundBlock == Blocks.field_150358_i) && (Integer)groundState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }
}

