/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.decoration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.ores.OreConfig;
import net.gegy1000.gengen.api.CubicPos;
import net.gegy1000.gengen.api.writer.ChunkPopulationWriter;
import net.gegy1000.gengen.core.GenGen;
import net.gegy1000.gengen.util.SpatialRandom;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.composer.decoration.DecorationComposer;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.minecraft.world.World;

public class OreDecorationComposer
implements DecorationComposer {
    private final ShortRaster.Sampler heightSampler = ShortRaster.sampler(EarthData.TERRAIN_HEIGHT);
    private final SpatialRandom random;
    private final Collection<OreConfig> ores = new ArrayList<OreConfig>();

    public OreDecorationComposer(World world) {
        this.random = new SpatialRandom(world, 1L);
    }

    public OreDecorationComposer add(OreConfig ... ores) {
        Collections.addAll(this.ores, ores);
        return this;
    }

    @Override
    public void composeDecoration(TerrariumWorld terrarium, CubicPos cubePos, ChunkPopulationWriter writer) {
        ColumnDataCache dataCache = terrarium.getDataCache();
        int x = cubePos.getMaxX();
        int z = cubePos.getMaxZ();
        int surfaceHeight = this.heightSampler.sample(dataCache, x, z);
        if (cubePos.getMinY() > surfaceHeight + 16) {
            return;
        }
        World world = writer.getGlobal();
        boolean cubic = GenGen.isCubic(world);
        this.random.setSeed(cubePos.getX(), cubePos.getY(), cubePos.getZ());
        if (!cubic) {
            surfaceHeight = Math.max(surfaceHeight, 64);
        }
        for (OreConfig ore : this.ores) {
            if (!ore.getSelector().shouldGenerateAt(dataCache, x, z)) continue;
            ore.getDistribution().forChunk(cubePos, surfaceHeight, this.random).forEach(pos -> {
                if (!cubic && pos.func_177956_o() <= 1) {
                    return;
                }
                ore.getGenerator().func_180709_b(world, (Random)this.random, pos);
            });
        }
    }
}

