/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.structure;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.world.compatibility.ColumnCompatibilityWorld;
import net.gegy1000.earth.server.world.composer.structure.data.LossyColumnCache;
import net.gegy1000.earth.server.world.composer.structure.data.StructureStartMap;
import net.gegy1000.earth.server.world.composer.structure.placement.StructurePlacement;
import net.gegy1000.gengen.api.CubicPos;
import net.gegy1000.gengen.api.HeightFunction;
import net.gegy1000.gengen.api.writer.ChunkPopulationWriter;
import net.gegy1000.gengen.api.writer.ChunkPrimeWriter;
import net.gegy1000.gengen.util.SpatialRandom;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.composer.structure.StructureComposer;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public final class ColumnStructureComposer
implements StructureComposer {
    public static final long SEED = 5805869966374122221L;
    private static final int COLUMN_RANGE = 8;
    private static final int COMPAT_SURFACE_Y = 64;
    private final World world;
    private final String structureName;
    private final StructurePlacement placement;
    private final StartConstructor startConstructor;
    private final HeightFunction surfaceFunction;
    private final Map<EnumCreatureType, List<Biome.SpawnListEntry>> creatures;
    private final SpatialRandom random;
    private final ColumnCompatibilityWorld compatibilityWorld;
    private final StructureStartMap structureStarts = new StructureStartMap(1024, 0.75f);
    private MapGenStructureData structureData;
    private final LossyColumnCache preparedColumnCache = new LossyColumnCache(256);
    private final LossyColumnCache preparedBoundsCache = new LossyColumnCache(64);
    private final StructureBoundingBox mutableBounds = new StructureBoundingBox();
    private final HookedBoundingBox hookedBounds = new HookedBoundingBox();

    private ColumnStructureComposer(World world, String structureName, StructurePlacement placement, StartConstructor startConstructor, HeightFunction surfaceFunction, Map<EnumCreatureType, List<Biome.SpawnListEntry>> creatures) {
        this.world = world;
        this.structureName = structureName;
        this.placement = placement;
        this.startConstructor = startConstructor;
        this.surfaceFunction = surfaceFunction;
        this.compatibilityWorld = new ColumnCompatibilityWorld(world);
        this.random = new SpatialRandom(world, 5805869966374122221L);
        this.creatures = creatures;
    }

    public static Builder builder() {
        return new Builder();
    }

    private MapGenStructureData prepareStructureData() {
        if (this.structureData != null) {
            return this.structureData;
        }
        MapStorage storage = this.world.getPerWorldStorage();
        this.structureData = (MapGenStructureData)storage.func_75742_a(MapGenStructureData.class, this.structureName);
        if (this.structureData == null) {
            this.structureData = new MapGenStructureData(this.structureName);
            storage.func_75745_a(this.structureName, (WorldSavedData)this.structureData);
        } else {
            this.deserializeStructureData(this.structureData.func_143041_a());
        }
        return this.structureData;
    }

    private void deserializeStructureData(NBTTagCompound root) {
        this.preparedColumnCache.clear();
        this.structureStarts.clear();
        for (String key : root.func_150296_c()) {
            NBTTagCompound compound;
            NBTBase tag = root.func_74781_a(key);
            if (tag.func_74732_a() != 10 || !(compound = (NBTTagCompound)tag).func_74764_b("ChunkX") || !compound.func_74764_b("ChunkZ")) continue;
            int chunkX = compound.func_74762_e("ChunkX");
            int chunkZ = compound.func_74762_e("ChunkZ");
            StructureStart start = MapGenStructureIO.func_143035_a((NBTTagCompound)compound, (World)this.world);
            if (start != null && start.func_143019_e() == chunkX && start.func_143018_f() == chunkZ) {
                this.structureStarts.put(start);
                continue;
            }
            TerrariumEarth.LOGGER.warn("Failed to deserialize structure start at ({}; {})", (Object)chunkX, (Object)chunkZ);
        }
    }

    private void writeStructureStart(StructureStart start) {
        MapGenStructureData data = this.prepareStructureData();
        int chunkX = start.func_143019_e();
        int chunkZ = start.func_143018_f();
        data.func_143043_a(start.func_143021_a(chunkX, chunkZ), chunkX, chunkZ);
        data.func_76185_a();
    }

    @Override
    public final void prepareStructures(TerrariumWorld terrarium, CubicPos pos) {
        this.prepareColumns(pos);
    }

    @Override
    public final void primeStructures(TerrariumWorld terrarium, CubicPos pos, ChunkPrimeWriter writer) {
        this.prepareColumns(pos);
    }

    private void prepareColumns(CubicPos pos) {
        int originX = pos.getX();
        int originZ = pos.getZ();
        for (int x = originX - 8; x <= originX + 8; ++x) {
            for (int z = originZ - 8; z <= originZ + 8; ++z) {
                this.random.setSeed(x, z);
                this.prepareColumn(x, z);
            }
        }
    }

    private void prepareColumn(int chunkX, int chunkZ) {
        if (this.preparedColumnCache.set(chunkX, chunkZ)) {
            return;
        }
        this.prepareStructureData();
        if (this.structureStarts.contains(chunkX, chunkZ)) {
            return;
        }
        if (this.placement.canSpawnAt(this.world, chunkX, chunkZ)) {
            StructureStart start = this.makeStart(chunkX, chunkZ);
            this.structureStarts.put(start);
            if (start.func_75069_d()) {
                this.writeStructureStart(start);
            }
        }
    }

    private StructureStart makeStart(int chunkX, int chunkZ) {
        ChunkPos columnPos = new ChunkPos(chunkX, chunkZ);
        ColumnCompatibilityWorld compatibilityWorld = this.getCompatibilityWorldFor(columnPos);
        return this.startConstructor.makeStart(compatibilityWorld, this.random, chunkX, chunkZ);
    }

    private ColumnCompatibilityWorld getCompatibilityWorldFor(ChunkPos columnPos) {
        int minY = this.getColumnOffsetFor(columnPos);
        return this.getCompatibilityWorldFor(columnPos, minY);
    }

    private ColumnCompatibilityWorld getCompatibilityWorldFor(ChunkPos columnPos, int minY) {
        this.compatibilityWorld.setupAt(columnPos, minY);
        return this.compatibilityWorld;
    }

    private int getColumnOffsetFor(ChunkPos columnPos) {
        int surfaceY = this.surfaceFunction.apply(columnPos.func_180334_c() + 8, columnPos.func_180333_d() + 8);
        surfaceY = Math.max(surfaceY, this.world.func_181545_F());
        return surfaceY - 64;
    }

    @Override
    public final void populateStructures(TerrariumWorld terrarium, CubicPos pos, ChunkPopulationWriter writer) {
        this.prepareStructureData();
        this.random.setSeed(pos.getCenterX(), pos.getCenterZ());
        ChunkPos columnPos = new ChunkPos(pos.getX(), pos.getZ());
        for (StructureStart start : this.structureStarts) {
            ChunkPos startColumnPos = new ChunkPos(start.func_143019_e(), start.func_143018_f());
            int columnOffsetY = this.getColumnOffsetFor(startColumnPos);
            StructureBoundingBox cubeBounds = this.getCubeBounds(pos, columnOffsetY);
            if (!start.func_75069_d() || !start.func_75071_a().func_78884_a(cubeBounds)) continue;
            ColumnCompatibilityWorld compatibilityWorld = this.getCompatibilityWorldFor(startColumnPos, columnOffsetY);
            if (!this.preparedBoundsCache.set(pos.getX(), pos.getZ())) {
                this.hookedBounds.set(cubeBounds);
                this.hookedBounds.field_78895_b = Integer.MIN_VALUE;
                this.hookedBounds.field_78894_e = Integer.MIN_VALUE;
                for (StructureComponent component : start.func_186161_c()) {
                    component.func_74875_a((World)compatibilityWorld, (Random)this.random, (StructureBoundingBox)this.hookedBounds);
                }
            }
            this.hookedBounds.set(cubeBounds);
            start.func_75068_a((World)compatibilityWorld, (Random)this.random, (StructureBoundingBox)this.hookedBounds);
            start.func_175787_b(columnPos);
            this.writeStructureStart(start);
        }
    }

    private StructureBoundingBox getCubeBounds(CubicPos pos, int offset) {
        this.mutableBounds.field_78897_a = pos.getCenterX();
        this.mutableBounds.field_78895_b = pos.getCenterY() - offset;
        this.mutableBounds.field_78896_c = pos.getCenterZ();
        this.mutableBounds.field_78893_d = this.mutableBounds.field_78897_a + 15;
        this.mutableBounds.field_78894_e = this.mutableBounds.field_78895_b + 15;
        this.mutableBounds.field_78892_f = this.mutableBounds.field_78896_c + 15;
        return this.mutableBounds;
    }

    @Override
    public final boolean isInsideStructure(TerrariumWorld terrarium, World world, String name, BlockPos pos) {
        if (!this.structureName.equals(name)) {
            return false;
        }
        for (StructureStart start : this.structureStarts) {
            if (!start.func_75069_d() || !start.func_75071_a().func_175898_b((Vec3i)pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public BlockPos getClosestStructure(TerrariumWorld terrarium, World world, String name, BlockPos pos, boolean findUnexplored) {
        if (this.structureName.equals(name)) {
            return this.placement.getClosestTo(world, pos, findUnexplored);
        }
        return null;
    }

    @Override
    @Nullable
    public List<Biome.SpawnListEntry> getPossibleCreatures(TerrariumWorld terrarium, World world, EnumCreatureType type, BlockPos pos) {
        if (this.isInsideStructure(terrarium, world, this.structureName, pos)) {
            return this.creatures.get(type);
        }
        return null;
    }

    static class GetCaller
    extends SecurityManager {
        static final GetCaller INSTANCE = new GetCaller();

        private GetCaller() {
        }

        public Class getCaller() {
            Class<?>[] ctx = this.getClassContext();
            return ctx[2];
        }
    }

    static class HookedBoundingBox
    extends StructureBoundingBox {
        HookedBoundingBox() {
        }

        public boolean func_175898_b(Vec3i vec) {
            if (vec.func_177956_o() == 64) {
                boolean horizontalCheck;
                boolean bl = horizontalCheck = vec.func_177958_n() >= this.field_78897_a && vec.func_177952_p() >= this.field_78896_c && vec.func_177958_n() <= this.field_78893_d && vec.func_177952_p() <= this.field_78892_f;
                if (!horizontalCheck) {
                    return false;
                }
                Class caller = GetCaller.INSTANCE.getCaller();
                if (HookedBoundingBox.isBoundCheckSpecialCase(caller)) {
                    return true;
                }
            }
            return super.func_175898_b(vec);
        }

        private static boolean isBoundCheckSpecialCase(Class caller) {
            if (caller == StructureVillagePieces.Path.class || caller == StructureVillagePieces.Village.class) {
                return true;
            }
            return caller.isMemberClass() && caller.getEnclosingClass() == ComponentScatteredFeaturePieces.class && caller != ComponentScatteredFeaturePieces.SwampHut.class;
        }

        public void set(StructureBoundingBox from) {
            this.field_78897_a = from.field_78897_a;
            this.field_78895_b = from.field_78895_b;
            this.field_78896_c = from.field_78896_c;
            this.field_78893_d = from.field_78893_d;
            this.field_78894_e = from.field_78894_e;
            this.field_78892_f = from.field_78892_f;
        }
    }

    public static class Builder {
        private String structureName;
        private StructurePlacement placement;
        private StartConstructor startConstructor;
        private HeightFunction surfaceFunction = (x, z) -> 64;
        private final Map<EnumCreatureType, List<Biome.SpawnListEntry>> creatures = new EnumMap<EnumCreatureType, List<Biome.SpawnListEntry>>(EnumCreatureType.class);

        Builder() {
        }

        public Builder setStructureName(String structureName) {
            this.structureName = structureName;
            return this;
        }

        public Builder setPlacement(StructurePlacement placement) {
            this.placement = placement;
            return this;
        }

        public Builder setStartConstructor(StartConstructor startConstructor) {
            this.startConstructor = startConstructor;
            return this;
        }

        public Builder setSurfaceFunction(HeightFunction surfaceFunction) {
            this.surfaceFunction = surfaceFunction;
            return this;
        }

        public Builder addCreatures(EnumCreatureType type, Biome.SpawnListEntry ... entries) {
            List creatures = this.creatures.computeIfAbsent(type, t -> new ArrayList());
            Collections.addAll(creatures, entries);
            return this;
        }

        public ColumnStructureComposer build(World world) {
            return new ColumnStructureComposer(world, (String)Preconditions.checkNotNull((Object)this.structureName, (Object)"no structure name"), (StructurePlacement)Preconditions.checkNotNull((Object)this.placement, (Object)"no placement"), (StartConstructor)Preconditions.checkNotNull((Object)this.startConstructor, (Object)"no start constructor"), this.surfaceFunction, this.creatures);
        }
    }

    public static interface StartConstructor {
        public StructureStart makeStart(World var1, Random var2, int var3, int var4);
    }
}

