/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.message.DisplayDownloadMessage;
import net.gegy1000.earth.server.message.UpdateDownloadMessage;
import net.gegy1000.justnow.executor.CurrentThreadExecutor;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.util.ChunkedIterator;
import net.gegy1000.terrarium.server.world.data.DataGenerator;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.source.DataSourceReader;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="earth")
public final class DataPreloader {
    private static final int BATCH_SIZE = 1000;
    private static DataPreloader active;
    private final DataGenerator generator;
    private final ChunkPos min;
    private final ChunkPos max;
    private final long total;
    private final Collection<EntityPlayerMP> watchers = new HashSet<EntityPlayerMP>();
    private boolean started;
    private final AtomicBoolean canceled = new AtomicBoolean();

    private DataPreloader(DataGenerator generator, ChunkPos min, ChunkPos max) {
        this.generator = generator;
        this.min = min;
        this.max = max;
        long width = max.field_77276_a - min.field_77276_a + 1;
        long height = max.field_77275_b - min.field_77275_b + 1;
        this.total = width * height;
    }

    public static boolean checkPermission(EntityPlayerMP player) {
        GameProfile profile;
        MinecraftServer server = player.func_184102_h();
        if (server == null) {
            return false;
        }
        PlayerList players = server.func_184103_al();
        if (!players.func_152596_g(profile = player.func_146103_bH())) {
            return false;
        }
        UserListOpsEntry op = (UserListOpsEntry)players.func_152603_m().func_152683_b((Object)profile);
        if (op != null) {
            return op.func_152644_a() >= 4;
        }
        return server.func_110455_j() >= 4;
    }

    public static DataPreloader open(TerrariumWorld terrarium, ChunkPos min, ChunkPos max) {
        return new DataPreloader(terrarium.getDataGenerator(), min, max);
    }

    public static Optional<DataPreloader> active() {
        return Optional.ofNullable(active);
    }

    public static boolean start(DataPreloader preloader) {
        if (active != null) {
            return false;
        }
        active = preloader;
        Thread thread = new Thread(() -> {
            try {
                preloader.drive();
            }
            finally {
                active = null;
            }
        });
        thread.setName("data-preloader");
        thread.setDaemon(true);
        thread.start();
        return true;
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            DataPreloader active = DataPreloader.active;
            if (active != null) {
                active.removeWatcher(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatcher(EntityPlayerMP player) {
        Collection<EntityPlayerMP> collection = this.watchers;
        synchronized (collection) {
            this.watchers.add(player);
        }
        if (this.started) {
            TerrariumEarth.NETWORK.sendTo((IMessage)new DisplayDownloadMessage(0L, this.total), player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatcher(EntityPlayerMP player) {
        Collection<EntityPlayerMP> collection = this.watchers;
        synchronized (collection) {
            this.watchers.remove(player);
        }
    }

    private void drive() {
        long count = 0L;
        Iterable chunks = ChunkedIterator.of(BlockPos.func_191532_a((int)this.min.field_77276_a, (int)0, (int)this.min.field_77275_b, (int)this.max.field_77276_a, (int)0, (int)this.max.field_77275_b), 1000);
        this.notifyWatchers(new DisplayDownloadMessage(count, this.total));
        this.started = true;
        for (Collection chunk : chunks) {
            for (BlockPos column : chunk) {
                DataView view = DataView.square(column.func_177958_n() << 4, column.func_177952_p() << 4, 16);
                this.generator.generate(view);
            }
            CurrentThreadExecutor.blockOn(DataSourceReader.INSTANCE.finishLoading());
            this.notifyWatchers(new UpdateDownloadMessage(count += (long)chunk.size()));
            if (!this.canceled.get()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWatchers(IMessage message) {
        Collection<EntityPlayerMP> collection = this.watchers;
        synchronized (collection) {
            for (EntityPlayerMP player : this.watchers) {
                TerrariumEarth.NETWORK.sendTo(message, player);
            }
        }
    }

    public void cancel() {
        this.canceled.set(true);
    }
}

