/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data.op;

import com.vividsolutions.jts.geom.MultiPolygon;
import java.util.ArrayList;
import java.util.Optional;
import net.gegy1000.earth.server.world.data.PolygonData;
import net.gegy1000.earth.server.world.data.op.PolygonClipper;
import net.gegy1000.terrarium.server.util.Vec2i;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.gegy1000.terrarium.server.world.coordinate.CoordinateReference;
import net.gegy1000.terrarium.server.world.data.DataOp;
import net.gegy1000.terrarium.server.world.data.source.DataSourceReader;
import net.gegy1000.terrarium.server.world.data.source.DataTileResult;
import net.gegy1000.terrarium.server.world.data.source.TiledDataSource;
import net.minecraft.util.math.MathHelper;

public final class PolygonSampler {
    public static DataOp<PolygonData> sample(TiledDataSource<PolygonData> source, CoordinateReference crs, double sampleExpand) {
        return DataOp.of((view, ctx) -> {
            Coordinate blockMin = view.getMinCoordinate().addLocal(-sampleExpand, -sampleExpand).to(crs);
            Coordinate blockMax = view.getMaxCoordinate().addLocal(sampleExpand, sampleExpand).to(crs);
            Coordinate min = Coordinate.min(blockMin, blockMax);
            Coordinate max = Coordinate.max(blockMin, blockMax);
            Vec2i minTilePos = PolygonSampler.getTilePos(source, min);
            Vec2i maxTilePos = PolygonSampler.getTilePos(source, max);
            return DataSourceReader.INSTANCE.getTiles(source, minTilePos, maxTilePos).andThen(tiles -> ctx.spawnBlocking(() -> {
                PolygonClipper clipper = PolygonClipper.rect(min.getX(), min.getZ(), max.getX(), max.getZ());
                ArrayList<MultiPolygon> polygons = new ArrayList<MultiPolygon>();
                for (DataTileResult entry : tiles) {
                    entry.data.ifPresent(data -> {
                        for (MultiPolygon polygon : data.getPolygons()) {
                            MultiPolygon clipped = clipper.clip(polygon);
                            if (clipped == null) continue;
                            polygons.add(clipped);
                        }
                    });
                }
                if (!polygons.isEmpty()) {
                    return Optional.of(new PolygonData(polygons));
                }
                return Optional.empty();
            }));
        });
    }

    private static Vec2i getTilePos(TiledDataSource<PolygonData> source, Coordinate coordinate) {
        return new Vec2i(MathHelper.func_76128_c((double)(coordinate.getX() / source.getTileWidth())), MathHelper.func_76128_c((double)(coordinate.getZ() / source.getTileHeight())));
    }
}

