/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data.source.cache;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.gegy1000.earth.server.util.IoFunction;
import net.gegy1000.earth.server.util.IoSupplier;
import net.gegy1000.earth.server.world.data.source.cache.TileCache;
import net.gegy1000.terrarium.Terrarium;
import org.apache.commons.io.IOUtils;

public final class CachingInput<T> {
    private static final ExecutorService CACHE_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("terrarium-cache-service").setDaemon(true).build());
    private final TileCache<T> cache;

    public CachingInput(TileCache<T> cache) {
        this.cache = cache;
    }

    public InputStream getInputStream(T key, IoFunction<T, InputStream> remoteFunction) throws IOException {
        InputStream localStream = this.cache.in(key);
        if (localStream != null) {
            return localStream;
        }
        InputStream remoteStream = remoteFunction.apply(key);
        OutputStream cacheStream = this.cache.out(key);
        if (cacheStream == null) {
            return remoteStream;
        }
        return CachingInput.getCachingStream(remoteStream, () -> cacheStream, e -> this.deleteQuietly(key));
    }

    public static InputStream getCachingStream(InputStream source, IoSupplier<OutputStream> destination, Consumer<IOException> error) throws IOException {
        PipedOutputStream sink = new PipedOutputStream();
        PipedInputStream input = new PipedInputStream(sink);
        CACHE_SERVICE.submit(() -> {
            try (OutputStream out = (OutputStream)destination.get();){
                int count;
                byte[] buffer = new byte[4096];
                while ((count = source.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                    sink.write(buffer, 0, count);
                }
            }
            catch (IOException e) {
                Terrarium.LOGGER.error("Failed to read or cache remote data", (Throwable)e);
                error.accept(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)source);
                IOUtils.closeQuietly((OutputStream)sink);
            }
        });
        return input;
    }

    private void deleteQuietly(T key) {
        try {
            this.cache.delete(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

