/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data.source.reader;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.ByteRaster;
import net.gegy1000.terrarium.server.world.data.raster.IntegerRaster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;

class RasterFormat<T extends IntegerRaster<?>> {
    static final RasterFormat<UByteRaster> UBYTE = new RasterFormat<UByteRaster>(UByteRaster.class, UByteRaster::create, (input, width, height) -> {
        byte[] bytes = new byte[width * height];
        new DataInputStream(input).readFully(bytes);
        return UByteRaster.wrap(bytes, width, height);
    });
    static final RasterFormat<ByteRaster> BYTE = new RasterFormat<ByteRaster>(ByteRaster.class, ByteRaster::create, (input, width, height) -> {
        byte[] bytes = new byte[width * height];
        new DataInputStream(input).readFully(bytes);
        return ByteRaster.wrap(bytes, width, height);
    });
    static final RasterFormat<ShortRaster> SHORT = new RasterFormat<ShortRaster>(ShortRaster.class, ShortRaster::create, (input, width, height) -> {
        DataInputStream dataIn = new DataInputStream(input);
        short[] values = new short[width * height];
        for (int i = 0; i < values.length; ++i) {
            values[i] = dataIn.readShort();
        }
        return ShortRaster.wrap(values, width, height);
    });
    private final Class<T> type;
    private final Function<DataView, T> constructor;
    private final RasterReader<T> reader;

    private RasterFormat(Class<T> type, Function<DataView, T> constructor, RasterReader<T> reader) {
        this.type = type;
        this.constructor = constructor;
        this.reader = reader;
    }

    T create(DataView view) {
        return (T)((IntegerRaster)this.constructor.apply(view));
    }

    T read(InputStream input, int width, int height) throws IOException {
        return this.reader.read(input, width, height);
    }

    <R extends IntegerRaster<?>> Optional<RasterFormat<R>> tryCast(Class<R> type) {
        if (!type.isAssignableFrom(this.type)) {
            return Optional.empty();
        }
        return Optional.of(this);
    }

    static Optional<RasterFormat<?>> byId(int id) {
        switch (id) {
            case 0: {
                return Optional.of(UBYTE);
            }
            case 1: {
                return Optional.of(BYTE);
            }
            case 2: {
                return Optional.of(SHORT);
            }
        }
        return Optional.empty();
    }

    static interface RasterReader<T extends IntegerRaster<?>> {
        public T read(InputStream var1, int var2, int var3) throws IOException;
    }
}

