/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology;

import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.world.Climate;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.cover.CoverMarkers;
import net.gegy1000.earth.server.world.ecology.maxent.feature.ConstFeature;
import net.gegy1000.earth.server.world.ecology.maxent.feature.GetPredictorFeature;
import net.gegy1000.earth.server.world.ecology.maxent.feature.MaxentFeature;
import net.gegy1000.earth.server.world.ecology.soil.SoilSuborder;
import net.gegy1000.earth.server.world.geography.Landform;
import net.gegy1000.terrarium.server.world.data.ColumnData;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.gegy1000.terrarium.server.world.data.raster.FloatRaster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;

public final class GrowthPredictors {
    public float elevation;
    public float annualRainfall;
    public float minTemperature;
    public float meanTemperature;
    public int cationExchangeCapacity;
    public int organicCarbonContent;
    public int pH;
    public int clayContent;
    public int siltContent;
    public int sandContent;
    public int slope;
    public Cover cover = Cover.NO;
    public SoilSuborder soilSuborder = SoilSuborder.NO;
    public Landform landform = Landform.LAND;

    public static Sampler sampler() {
        return new Sampler();
    }

    public static MaxentFeature featureById(String id) {
        switch (id) {
            case "elevation": {
                return new GetPredictorFeature("elevation", Float.TYPE);
            }
            case "annual_precipitation": {
                return new GetPredictorFeature("annualRainfall", Float.TYPE);
            }
            case "average_temperature": {
                return new GetPredictorFeature("meanTemperature", Float.TYPE);
            }
            case "cation_exchange_capacity": {
                return new GetPredictorFeature("cationExchangeCapacity", Integer.TYPE);
            }
            case "organic_carbon_content": {
                return new GetPredictorFeature("organicCarbonContent", Integer.TYPE);
            }
            case "ph": {
                return new GetPredictorFeature("pH", Integer.TYPE);
            }
            case "clay_content": {
                return new GetPredictorFeature("clayContent", Integer.TYPE);
            }
            case "silt_content": {
                return new GetPredictorFeature("siltContent", Integer.TYPE);
            }
            case "sand_content": {
                return new GetPredictorFeature("sandContent", Integer.TYPE);
            }
            case "slope": {
                return new GetPredictorFeature("sloe", Integer.TYPE);
            }
        }
        TerrariumEarth.LOGGER.warn("invalid predictor id: {}", (Object)id);
        return new ConstFeature(0.0f);
    }

    public boolean isSea() {
        return this.landform == Landform.SEA;
    }

    public boolean isRiverOrLake() {
        return this.landform == Landform.LAKE_OR_RIVER;
    }

    public boolean isLand() {
        return this.landform.isLand();
    }

    public boolean isFrozen() {
        return Climate.isFrozen(this.minTemperature, this.meanTemperature) || this.cover.is(CoverMarkers.FROZEN);
    }

    public boolean isCold() {
        return Climate.isCold(this.meanTemperature) || this.isFrozen();
    }

    public boolean isForested() {
        return this.cover.is(CoverMarkers.FOREST);
    }

    public boolean isFlooded() {
        return this.cover.is(CoverMarkers.FLOODED);
    }

    public boolean isBarren() {
        return this.cover.is(CoverMarkers.BARREN);
    }

    public static class Sampler {
        private final FloatRaster.Sampler elevation = FloatRaster.sampler(EarthData.ELEVATION_METERS).defaultValue(-3.4028235E38f);
        private final ShortRaster.Sampler annualRainfall = ShortRaster.sampler(EarthData.ANNUAL_RAINFALL).defaultValue(300);
        private final FloatRaster.Sampler meanTemperature = FloatRaster.sampler(EarthData.MEAN_TEMPERATURE).defaultValue(14.0f);
        private final FloatRaster.Sampler minTemperature = FloatRaster.sampler(EarthData.MIN_TEMPERATURE).defaultValue(10.0f);
        private final UByteRaster.Sampler cationExchangeCapacity = UByteRaster.sampler(EarthData.CATION_EXCHANGE_CAPACITY).defaultValue(10);
        private final ShortRaster.Sampler organicCarbonContent = ShortRaster.sampler(EarthData.ORGANIC_CARBON_CONTENT).defaultValue(10);
        private final UByteRaster.Sampler pH = UByteRaster.sampler(EarthData.SOIL_PH).defaultValue(70);
        private final UByteRaster.Sampler clayContent = UByteRaster.sampler(EarthData.CLAY_CONTENT).defaultValue(33);
        private final UByteRaster.Sampler siltContent = UByteRaster.sampler(EarthData.SILT_CONTENT).defaultValue(33);
        private final UByteRaster.Sampler sandContent = UByteRaster.sampler(EarthData.SAND_CONTENT).defaultValue(33);
        private final UByteRaster.Sampler slope = UByteRaster.sampler(EarthData.SLOPE).defaultValue(0);
        private final EnumRaster.Sampler<Cover> cover = EnumRaster.sampler(EarthData.COVER, Cover.NO);
        private final EnumRaster.Sampler<SoilSuborder> soilSuborder = EnumRaster.sampler(EarthData.SOIL_SUBORDER, SoilSuborder.NO);
        private final EnumRaster.Sampler<Landform> landform = EnumRaster.sampler(EarthData.LANDFORM, Landform.LAND);

        Sampler() {
        }

        public GrowthPredictors sample(ColumnDataCache dataCache, int x, int z) {
            GrowthPredictors predictors = new GrowthPredictors();
            this.sampleTo(dataCache, x, z, predictors);
            return predictors;
        }

        public GrowthPredictors sample(ColumnData data, int x, int z) {
            GrowthPredictors predictors = new GrowthPredictors();
            this.sampleTo(data, x, z, predictors);
            return predictors;
        }

        public void sampleTo(ColumnDataCache dataCache, int x, int z, GrowthPredictors predictors) {
            ColumnData data = dataCache.joinData(x >> 4, z >> 4);
            this.sampleTo(data, x & 0xF, z & 0xF, predictors);
        }

        public void sampleTo(ColumnData data, int x, int z, GrowthPredictors predictors) {
            predictors.elevation = this.elevation.sample(data, x, z);
            predictors.annualRainfall = this.annualRainfall.sample(data, x, z);
            predictors.meanTemperature = this.meanTemperature.sample(data, x, z);
            predictors.minTemperature = this.minTemperature.sample(data, x, z);
            predictors.cationExchangeCapacity = this.cationExchangeCapacity.sample(data, x, z);
            predictors.organicCarbonContent = this.organicCarbonContent.sample(data, x, z);
            predictors.pH = this.pH.sample(data, x, z);
            predictors.clayContent = this.clayContent.sample(data, x, z);
            predictors.siltContent = this.siltContent.sample(data, x, z);
            predictors.sandContent = this.sandContent.sample(data, x, z);
            predictors.slope = this.slope.sample(data, x, z);
            predictors.cover = this.cover.sample(data, x, z);
            predictors.soilSuborder = this.soilSuborder.sample(data, x, z);
            predictors.landform = this.landform.sample(data, x, z);
        }
    }
}

