/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.maxent;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nullable;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.maxent.MaxentParseException;
import net.gegy1000.earth.server.world.ecology.maxent.feature.MaxentFeature;
import net.gegy1000.earth.server.world.ecology.maxent.feature.MaxentFeatures;
import net.minecraft.util.ResourceLocation;

public final class MaxentLambdasFile {
    private final ImmutableList<MaxentFeature> features;
    private final Object2FloatMap<String> fields;

    private MaxentLambdasFile(ImmutableList<MaxentFeature> features, Object2FloatMap<String> fields) {
        this.features = features;
        this.fields = fields;
    }

    public static MaxentLambdasFile parse(ResourceLocation location) throws IOException, MaxentParseException {
        String path = "/data/" + location.func_110624_b() + "/" + location.func_110623_a();
        try (InputStream input = TerrariumEarth.class.getResourceAsStream(path);){
            MaxentLambdasFile maxentLambdasFile = MaxentLambdasFile.parse(input);
            return maxentLambdasFile;
        }
    }

    public static MaxentLambdasFile parse(InputStream input) throws IOException, MaxentParseException {
        String line;
        Object2FloatOpenHashMap fields = new Object2FloatOpenHashMap();
        ImmutableList.Builder features = ImmutableList.builder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split(", ");
            if (tokens.length == 2) {
                String key = tokens[0];
                float value = Float.parseFloat(tokens[1]);
                fields.put((Object)key, value);
                continue;
            }
            if (tokens.length == 4) {
                MaxentFeature feature = MaxentLambdasFile.parseFeature(tokens);
                if (feature == null) continue;
                features.add((Object)feature);
                continue;
            }
            throw new MaxentParseException("Unexpected line format: " + line);
        }
        return new MaxentLambdasFile((ImmutableList<MaxentFeature>)features.build(), (Object2FloatMap<String>)fields);
    }

    @Nullable
    public static MaxentFeature parseFeature(String line) throws MaxentParseException {
        return MaxentLambdasFile.parseFeature(line.split(", "));
    }

    @Nullable
    public static MaxentFeature parseFeature(String[] tokens) throws MaxentParseException {
        if (tokens.length != 4) {
            throw new MaxentParseException("Invalid number of tokens for feature");
        }
        try {
            String ident = tokens[0];
            float lambda = Float.parseFloat(tokens[1]);
            if (Math.abs(lambda) <= 1.0E-6f) {
                return null;
            }
            float min = Float.parseFloat(tokens[2]);
            float max = Float.parseFloat(tokens[3]);
            if (ident.startsWith("(") && ident.endsWith(")")) {
                String expression = ident.substring(1, ident.length() - 1);
                return MaxentLambdasFile.parseExpressionFeature(expression, lambda, min, max);
            }
            if (ident.startsWith("'")) {
                MaxentFeature feature = GrowthPredictors.featureById(ident.substring(1));
                return MaxentFeatures.hinge(feature, lambda, min, max);
            }
            if (ident.startsWith("`")) {
                MaxentFeature feature = GrowthPredictors.featureById(ident.substring(1));
                return MaxentFeatures.reverseHinge(feature, lambda, min, max);
            }
            if (ident.contains("*")) {
                int idx = ident.indexOf(42);
                MaxentFeature left = GrowthPredictors.featureById(ident.substring(0, idx));
                MaxentFeature right = GrowthPredictors.featureById(ident.substring(idx + 1));
                return MaxentFeatures.product(left, right, lambda, min, max);
            }
            if (ident.contains("^2")) {
                MaxentFeature feature = GrowthPredictors.featureById(ident.substring(0, ident.length() - 2));
                return MaxentFeatures.quadratic(feature, lambda, min, max);
            }
            MaxentFeature feature = GrowthPredictors.featureById(ident);
            return MaxentFeatures.raw(feature, lambda, min, max);
        }
        catch (NumberFormatException e) {
            throw new MaxentParseException("Malformed number", e);
        }
    }

    private static MaxentFeature parseExpressionFeature(String expression, float lambda, float min, float max) throws MaxentParseException {
        int idxEq = expression.indexOf(61);
        int idxLt = expression.indexOf(60);
        if (idxEq != -1) {
            MaxentFeature feature = GrowthPredictors.featureById(expression.substring(0, idxEq));
            float value = Float.parseFloat(expression.substring(idxEq));
            return MaxentFeatures.equal(feature, lambda, min, max, value);
        }
        if (idxLt != -1) {
            MaxentFeature feature = GrowthPredictors.featureById(expression.substring(idxLt));
            float threshold = Float.parseFloat(expression.substring(0, idxLt));
            return MaxentFeatures.threshold(feature, lambda, min, max, threshold);
        }
        throw new MaxentParseException("Invalid expression operator");
    }

    public ImmutableList<MaxentFeature> getFeatures() {
        return this.features;
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    public float getFieldOr(String key, float or) {
        if (this.fields.containsKey((Object)key)) {
            return this.fields.getFloat((Object)key);
        }
        return or;
    }
}

