/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.vegetation;

import net.gegy1000.earth.server.world.ecology.vegetation.Trees;
import net.gegy1000.earth.server.world.ecology.vegetation.Vegetation;
import net.gegy1000.earth.server.world.ecology.vegetation.VegetationGenerator;
import net.gegy1000.earth.server.world.feature.FloorShrubFeature;
import net.gegy1000.earth.server.world.feature.TallShrubFeature;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public final class Shrubs {
    public static final float RADIUS = 1.5f;
    public static final Vegetation TALL_ACACIA = Vegetation.builder().generator(Generators.TALL_ACACIA).growthIndicator(Trees.Indicators.ACACIA).build();
    public static final Vegetation TALL_BIRCH = Vegetation.builder().generator(Generators.TALL_BIRCH).growthIndicator(Trees.Indicators.BIRCH).build();
    public static final Vegetation TALL_OAK = Vegetation.builder().generator(Generators.TALL_OAK).growthIndicator(Trees.Indicators.OAK).build();
    public static final Vegetation TALL_JUNGLE = Vegetation.builder().generator(Generators.TALL_JUNGLE).growthIndicator(Trees.Indicators.JUNGLE_LIKE).build();
    public static final Vegetation TALL_SPRUCE = Vegetation.builder().generator(Generators.TALL_SPRUCE).growthIndicator(Trees.Indicators.SPRUCE).build();
    public static final Vegetation FLOOR_ACACIA = Vegetation.builder().generator(Generators.FLOOR_ACACIA).growthIndicator(Trees.Indicators.ACACIA).build();
    public static final Vegetation FLOOR_BIRCH = Vegetation.builder().generator(Generators.FLOOR_BIRCH).growthIndicator(Trees.Indicators.BIRCH).build();
    public static final Vegetation FLOOR_OAK = Vegetation.builder().generator(Generators.FLOOR_OAK).growthIndicator(Trees.Indicators.OAK).build();
    public static final Vegetation FLOOR_JUNGLE = Vegetation.builder().generator(Generators.FLOOR_JUNGLE).growthIndicator(Trees.Indicators.JUNGLE_LIKE).build();
    public static final Vegetation FLOOR_SPRUCE = Vegetation.builder().generator(Generators.FLOOR_SPRUCE).growthIndicator(Trees.Indicators.SPRUCE).build();

    static class Generators {
        static final VegetationGenerator TALL_ACACIA = Generators.tallShrub(BlockPlanks.EnumType.ACACIA);
        static final VegetationGenerator TALL_BIRCH = Generators.tallShrub(BlockPlanks.EnumType.BIRCH);
        static final VegetationGenerator TALL_OAK = Generators.tallShrub(BlockPlanks.EnumType.OAK);
        static final VegetationGenerator TALL_JUNGLE = Generators.tallShrub(BlockPlanks.EnumType.JUNGLE);
        static final VegetationGenerator TALL_SPRUCE = Generators.tallShrub(BlockPlanks.EnumType.SPRUCE);
        static final VegetationGenerator FLOOR_ACACIA = Generators.floorShrub(BlockPlanks.EnumType.ACACIA);
        static final VegetationGenerator FLOOR_BIRCH = Generators.floorShrub(BlockPlanks.EnumType.BIRCH);
        static final VegetationGenerator FLOOR_OAK = Generators.floorShrub(BlockPlanks.EnumType.OAK);
        static final VegetationGenerator FLOOR_JUNGLE = Generators.floorShrub(BlockPlanks.EnumType.JUNGLE);
        static final VegetationGenerator FLOOR_SPRUCE = Generators.floorShrub(BlockPlanks.EnumType.SPRUCE);

        Generators() {
        }

        private static VegetationGenerator tallShrub(BlockPlanks.EnumType type) {
            return VegetationGenerator.of(new TallShrubFeature(false, Generators.log(type), Generators.leaf(type)));
        }

        private static VegetationGenerator floorShrub(BlockPlanks.EnumType type) {
            return VegetationGenerator.of(new FloorShrubFeature(false, Generators.log(type), Generators.leaf(type)));
        }

        private static IBlockState log(BlockPlanks.EnumType type) {
            if (type.func_176839_a() < 4) {
                return Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)type);
            }
            return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)type);
        }

        private static IBlockState leaf(BlockPlanks.EnumType type) {
            if (type.func_176839_a() < 4) {
                return Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)type).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
            }
            return Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)type).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        }
    }
}

