/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.vegetation;

import java.util.Random;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.vegetation.Vegetation;
import net.gegy1000.earth.server.world.ecology.vegetation.VegetationGenerator;
import net.gegy1000.gengen.api.CubicPos;
import net.gegy1000.gengen.api.writer.ChunkPopulationWriter;
import net.gegy1000.terrarium.server.util.WeightedPool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorSimplex;

public final class TreeDecorator {
    private static final int CHUNK_AREA = 256;
    private static final NoiseGeneratorSimplex DENSITY_NOISE = new NoiseGeneratorSimplex(new Random(21L));
    private final WeightedPool<VegetationGenerator> pool;
    private float minDensity = 0.5f;
    private float maxDensity = 0.5f;
    private float area = 1.0f;
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public TreeDecorator(WeightedPool<VegetationGenerator> pool) {
        this.pool = pool;
    }

    public void decorate(ChunkPopulationWriter writer, CubicPos cubePos, Random random) {
        if (this.pool.isEmpty()) {
            return;
        }
        World world = writer.getGlobal();
        int minX = cubePos.getCenterX();
        int minZ = cubePos.getCenterZ();
        float densityNoise = (float)(DENSITY_NOISE.func_151605_a((double)cubePos.getX(), (double)cubePos.getZ()) + 1.0) / 2.0f;
        float density = this.minDensity + (this.maxDensity - this.minDensity) * densityNoise;
        float fCount = density * 256.0f / this.area;
        int count = MathHelper.func_76141_d((float)fCount);
        float remainder = fCount - (float)count;
        if (random.nextFloat() < remainder) {
            ++count;
        }
        for (int i = 0; i < count; ++i) {
            VegetationGenerator vegetation;
            int x = minX + random.nextInt(16);
            int z = minZ + random.nextInt(16);
            this.mutablePos.func_181079_c(x, 0, z);
            if (!writer.getSurfaceMut(this.mutablePos) || (vegetation = this.pool.sampleOrNull(random)) == null) continue;
            vegetation.generate(world, random, (BlockPos)this.mutablePos);
        }
    }

    public static class Builder {
        private static final double MIN_SUITABILITY_THRESHOLD = 0.1;
        private static final double SUITABILITY_THRESHOLD = 0.85;
        private final GrowthPredictors predictors;
        private final WeightedPool<VegetationGenerator> pool = new WeightedPool();
        private VegetationGenerator mostSuitable;
        private double mostSuitableIndicator;
        private float area = 1.0f;
        private float minDensity = 0.0f;
        private float maxDensity = 0.2f;

        public Builder(GrowthPredictors predictors) {
            this.predictors = predictors;
        }

        public Builder addCandidate(Vegetation vegetation) {
            double indicator = vegetation.getGrowthIndicator().evaluate(this.predictors);
            if (indicator > 0.85) {
                this.pool.add(vegetation.getGenerator(), (float)indicator);
            }
            if (indicator > this.mostSuitableIndicator) {
                this.mostSuitable = vegetation.getGenerator();
                this.mostSuitableIndicator = indicator;
            }
            return this;
        }

        public Builder setDensity(float minDensity, float maxDensity) {
            this.minDensity = minDensity;
            this.maxDensity = maxDensity;
            return this;
        }

        public Builder setRadius(float radius) {
            this.area = (float)(Math.PI * (double)radius * (double)radius);
            return this;
        }

        public Builder setArea(float area) {
            this.area = area;
            return this;
        }

        public TreeDecorator build() {
            if (this.pool.isEmpty() && this.mostSuitable != null && this.mostSuitableIndicator > 0.1) {
                this.pool.add(this.mostSuitable, (float)this.mostSuitableIndicator);
            }
            TreeDecorator decorator = new TreeDecorator(this.pool);
            decorator.minDensity = this.minDensity;
            decorator.maxDensity = this.maxDensity;
            decorator.area = this.area;
            return decorator;
        }
    }
}

