/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.vegetation;

import net.gegy1000.earth.server.event.CollectTreeGeneratorsEvent;
import net.gegy1000.earth.server.world.ecology.SoilPredicate;
import net.gegy1000.earth.server.world.ecology.vegetation.VegetationGenerator;
import net.gegy1000.earth.server.world.feature.HookGrowthCheckFeature;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class TreeGenerators {
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.FALSE);
    public VegetationGenerator acacia = VegetationGenerator.noop();
    public VegetationGenerator birch = VegetationGenerator.noop();
    public VegetationGenerator oak = VegetationGenerator.noop();
    public VegetationGenerator jungle = VegetationGenerator.noop();
    public VegetationGenerator bigJungle = VegetationGenerator.noop();
    public VegetationGenerator spruce = VegetationGenerator.noop();
    public VegetationGenerator pine = VegetationGenerator.noop();

    public static TreeGenerators collect() {
        TreeGenerators generators = TreeGenerators.vanilla();
        CollectTreeGeneratorsEvent event = new CollectTreeGeneratorsEvent(generators);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return generators;
    }

    private static TreeGenerators vanilla() {
        TreeGenerators vanilla = new TreeGenerators();
        WorldGenerator oak = TreeGenerators.hook((WorldGenerator)new WorldGenTrees(false));
        WorldGenerator bigOak = TreeGenerators.hook((WorldGenerator)new WorldGenBigTree(false));
        vanilla.acacia = TreeGenerators.tree((WorldGenerator)new WorldGenSavannaTree(false));
        vanilla.birch = TreeGenerators.tree((WorldGenerator)new WorldGenBirchTree(false, false));
        vanilla.oak = (world, random, pos) -> {
            if (random.nextInt(10) == 0) {
                bigOak.func_180709_b(world, random, pos);
            } else {
                oak.func_180709_b(world, random, pos);
            }
        };
        vanilla.jungle = TreeGenerators.tree((WorldGenerator)new WorldGenTrees(false, 7, JUNGLE_LOG, JUNGLE_LEAF, true));
        vanilla.bigJungle = TreeGenerators.tree((WorldGenerator)new WorldGenMegaJungle(false, 10, 20, JUNGLE_LOG, JUNGLE_LEAF));
        vanilla.pine = TreeGenerators.tree((WorldGenerator)new WorldGenTaiga1());
        vanilla.spruce = TreeGenerators.tree((WorldGenerator)new WorldGenTaiga2(false));
        return vanilla;
    }

    private static VegetationGenerator tree(WorldGenerator generator) {
        return VegetationGenerator.of(TreeGenerators.hook(generator));
    }

    private static WorldGenerator hook(WorldGenerator generator) {
        return new HookGrowthCheckFeature(generator, SoilPredicate.ANY);
    }
}

