/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ores;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Random;
import net.gegy1000.earth.server.world.ores.OreDistribution;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public final class OreConfig {
    private final WorldGenerator generator;
    private final OreDistribution distribution;
    private final Selector selector;

    private OreConfig(WorldGenerator generator, OreDistribution distribution, Selector selector) {
        this.generator = generator;
        this.distribution = distribution;
        this.selector = selector;
    }

    public static Builder builder() {
        return new Builder();
    }

    public WorldGenerator getGenerator() {
        return this.generator;
    }

    public OreDistribution getDistribution() {
        return this.distribution;
    }

    public Selector getSelector() {
        return this.selector;
    }

    static class SingleOreGenerator
    extends WorldGenerator {
        private final IBlockState ore;
        private final Predicate<IBlockState> targetPredicate;

        SingleOreGenerator(IBlockState ore, Predicate<IBlockState> targetPredicate) {
            this.ore = ore;
            this.targetPredicate = targetPredicate;
        }

        SingleOreGenerator(IBlockState ore) {
            this(ore, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        }

        public boolean func_180709_b(World world, Random random, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos = pos.func_177982_a(8, 0, 8));
            if (state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, this.targetPredicate)) {
                world.func_180501_a(pos, this.ore, 18);
            }
            return true;
        }
    }

    public static interface Selector {
        public boolean shouldGenerateAt(ColumnDataCache var1, int var2, int var3);
    }

    public static class Builder {
        private IBlockState ore;
        private OreDistribution distribution;
        private int size = 1;
        private Selector selector;

        Builder() {
        }

        public Builder ore(IBlockState state) {
            this.ore = state;
            return this;
        }

        public Builder distribution(OreDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder select(Selector selector) {
            this.selector = selector;
            return this;
        }

        public OreConfig build() {
            Preconditions.checkNotNull((Object)this.ore, (Object)"ore state not set");
            Preconditions.checkNotNull((Object)this.distribution, (Object)"distribution not set");
            WorldGenerator generator = this.buildGenerator();
            Selector selector = this.selector != null ? this.selector : (cache, x, z) -> true;
            return new OreConfig(generator, this.distribution, selector);
        }

        private WorldGenerator buildGenerator() {
            if (this.size == 1) {
                return new SingleOreGenerator(this.ore);
            }
            return new WorldGenMinable(this.ore, this.size);
        }
    }
}

