/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ores;

import java.util.Random;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.gegy1000.gengen.api.CubicPos;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public interface OreDistribution {
    public static final int VANILLA_SURFACE_Y = 62;

    public Stream<BlockPos> forChunk(CubicPos var1, int var2, Random var3);

    public static OreDistribution vanillaUniform(int count, int maxY) {
        double maxCubeY = (double)maxY / 16.0;
        double countPerCube = (double)count / maxCubeY;
        return OreDistribution.uniform(countPerCube, maxY - 62);
    }

    public static OreDistribution vanillaBand(int count, int centerY, int spreadY) {
        int minY = centerY - spreadY;
        int maxY = centerY + spreadY;
        double cubeRangeY = (double)(maxY - minY) / 16.0;
        double countPerCube = (double)count / cubeRangeY;
        return OreDistribution.band(countPerCube, minY - 62, maxY - 62);
    }

    public static OreDistribution band(double countPerCube, int minY, int maxY) {
        return OreDistribution.uniformWithin(countPerCube, y -> y >= minY && y <= maxY);
    }

    public static OreDistribution uniform(double countPerCube, int maxY) {
        return OreDistribution.uniformWithin(countPerCube, y -> y <= maxY);
    }

    public static OreDistribution uniformWithin(double countPerCube, IntPredicate validY) {
        return (cubePos, surfaceHeight, random) -> {
            BlockPos cubeOrigin = new BlockPos(cubePos.getMinX(), cubePos.getCenterY(), cubePos.getMinZ());
            int minRelativeY = cubeOrigin.func_177956_o() - surfaceHeight;
            int maxRelativeY = cubeOrigin.func_177956_o() + 16 - surfaceHeight;
            if (!validY.test(minRelativeY) && !validY.test(maxRelativeY)) {
                return Stream.empty();
            }
            int count = MathHelper.func_76128_c((double)countPerCube);
            double remainder = countPerCube - (double)count;
            if ((double)random.nextFloat() < remainder) {
                ++count;
            }
            if (count <= 0) {
                return Stream.empty();
            }
            return IntStream.range(0, count).mapToObj(v -> cubeOrigin.func_177982_a(random.nextInt(16), random.nextInt(16), random.nextInt(16))).filter(pos -> validY.test(pos.func_177956_o() - surfaceHeight));
        };
    }
}

