/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.gengen.core;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.gegy1000.gengen.core.GenGenProxy;
import net.gegy1000.gengen.core.GenGenWorldProxy;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GenGen {
    public static final Logger LOGGER = LogManager.getLogger(GenGen.class);
    private static Field isCubicField;
    private static final Map<World, GenGenWorldProxy> WORLD_PROXY;
    private static GenGenProxy proxy;

    public static GenGenProxy proxy() {
        if (proxy == null) {
            proxy = Loader.isModLoaded((String)"cubicchunks") ? new GenGenProxy.Cubic() : new GenGenProxy.Vanilla();
        }
        return proxy;
    }

    public static GenGenWorldProxy proxy(World world) {
        return WORLD_PROXY.computeIfAbsent(world, w -> GenGen.isCubic(w) ? new GenGenWorldProxy.Cubic() : new GenGenWorldProxy.Vanilla());
    }

    public static boolean isCubic(World world) {
        if (isCubicField == null) {
            return false;
        }
        try {
            return isCubicField.getBoolean(world);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to check isCubicWorld field", (Throwable)e);
            return false;
        }
    }

    static {
        try {
            isCubicField = ReflectionHelper.findField(World.class, (String[])new String[]{"isCubicWorld"});
            isCubicField.setAccessible(true);
        }
        catch (ReflectionHelper.UnableToFindFieldException unableToFindFieldException) {
            // empty catch block
        }
        WORLD_PROXY = new WeakHashMap<World, GenGenWorldProxy>();
    }
}

