/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.gengen.core.impl.vanilla;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.gegy1000.gengen.api.CubicPos;
import net.gegy1000.gengen.api.generator.GenericChunkGenerator;
import net.gegy1000.gengen.core.impl.vanilla.ColumnPopulationWriterImpl;
import net.gegy1000.gengen.core.impl.vanilla.ColumnPrimeWriterImpl;
import net.gegy1000.gengen.util.SpatialRandom;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ColumnGeneratorImpl
implements IChunkGenerator {
    private final World world;
    private final GenericChunkGenerator generator;
    private final SpatialRandom random;
    private Biome[] biomeBuffer = new Biome[256];

    public ColumnGeneratorImpl(World world, GenericChunkGenerator generator) {
        this.world = world;
        this.generator = generator;
        this.random = new SpatialRandom(world, 0L);
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer primer = new ChunkPrimer();
        for (int y = 0; y < 16; ++y) {
            CubicPos pos = new CubicPos(x, y, z);
            this.generator.primeChunk(pos, new ColumnPrimeWriterImpl(primer, pos));
        }
        Chunk chunk = new Chunk(this.world, primer, x, z);
        this.populateBiomes(chunk);
        this.generator.generateColumn(chunk);
        chunk.func_76603_b();
        return chunk;
    }

    private void populateBiomes(Chunk chunk) {
        this.biomeBuffer = this.world.func_72959_q().func_76933_b(this.biomeBuffer, chunk.field_76635_g << 4, chunk.field_76647_h << 4, 16, 16);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < this.biomeBuffer.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomeBuffer[i]);
        }
    }

    public void func_185931_b(int x, int z) {
        this.random.setSeed(x << 4, z << 4);
        for (int y = 0; y < 16; ++y) {
            CubicPos pos = new CubicPos(x, y, z);
            this.generator.populateChunk(pos, new ColumnPopulationWriterImpl(this.world, pos));
        }
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
        return this.generator.getPossibleCreatures(type, pos);
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    @Nullable
    public BlockPos func_180513_a(World world, String name, BlockPos pos, boolean findUnexplored) {
        return this.generator.getClosestStructure(name, pos, findUnexplored);
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        for (int y = 0; y < 16; ++y) {
            this.generator.prepareStructures(new CubicPos(x, y, z));
        }
    }

    public boolean func_193414_a(World world, String name, BlockPos pos) {
        return this.generator.isInsideStructure(name, pos);
    }

    public GenericChunkGenerator getInner() {
        return this.generator;
    }
}

