/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.gengen.core.impl.vanilla;

import java.lang.reflect.Field;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.gegy1000.gengen.api.GenericWorldType;
import net.gegy1000.gengen.api.generator.GenericChunkGenerator;
import net.gegy1000.gengen.core.GenGen;
import net.gegy1000.gengen.core.impl.vanilla.ColumnGeneratorImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ColumnWorldTypeImpl
extends WorldType {
    private static Field nameField;
    protected final GenericWorldType worldType;

    public ColumnWorldTypeImpl(GenericWorldType worldType) {
        super(nameField == null ? worldType.getName() : "lbps");
        this.worldType = worldType;
        ColumnWorldTypeImpl.setName(this, worldType.getName());
    }

    private static void setName(WorldType worldType, String name) {
        if (nameField != null) {
            try {
                nameField.set(worldType, name);
            }
            catch (IllegalAccessException e) {
                GenGen.LOGGER.error("Failed to set world type name", (Throwable)e);
            }
        }
    }

    public IChunkGenerator getChunkGenerator(World world, String generationSettings) {
        GenericChunkGenerator generator = this.worldType.createGenerator(world);
        return new ColumnGeneratorImpl(world, generator);
    }

    public BiomeProvider getBiomeProvider(World world) {
        return this.worldType.createBiomeProvider(world);
    }

    public double getHorizon(World world) {
        return this.worldType.getHorizon(world);
    }

    public boolean handleSlimeSpawnReduction(Random random, World world) {
        return this.worldType.shouldReduceSlimes(world, random);
    }

    public int getSpawnFuzz(WorldServer world, MinecraftServer server) {
        return this.worldType.getSpawnFuzz(world, server);
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft client, GuiCreateWorld parent) {
        this.worldType.onCustomize(client, this, parent);
    }

    public boolean isCustomizable() {
        return this.worldType.isCustomizable();
    }

    public float getCloudHeight() {
        return this.worldType.getCloudHeight();
    }

    public GenericWorldType getInner() {
        return this.worldType;
    }

    static {
        try {
            nameField = ReflectionHelper.findField(WorldType.class, (String[])new String[]{"name", "field_77133_f"});
            if (nameField != null) {
                nameField.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(nameField, nameField.getModifiers() & 0xFFFFFFEF);
            } else {
                GenGen.LOGGER.error("Failed to find world type name field");
            }
        }
        catch (ReflectiveOperationException e) {
            GenGen.LOGGER.error("Failed to get world type name field", (Throwable)e);
        }
    }
}

