/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.gengen.util.primer;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.gegy1000.gengen.api.CubicPos;
import net.gegy1000.gengen.api.generator.GenericChunkPrimer;
import net.gegy1000.gengen.api.writer.ChunkPrimeWriter;
import net.gegy1000.gengen.util.primer.CubicStructureUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GenericCavePrimer
implements GenericChunkPrimer {
    private static final int RANGE = 8;
    private static final int CAVE_RARITY = 14;
    private static final int MAX_INIT_NODES = 14;
    private static final int LARGE_NODE_RARITY = 4;
    private static final int LARGE_NODE_MAX_BRANCHES = 4;
    private static final int BIG_CAVE_RARITY = 10;
    private static final double CAVE_SIZE_ADD = 1.5;
    private static final int STEEP_STEP_RARITY = 6;
    private static final float FLATTEN_FACTOR = 0.7f;
    private static final float STEEPER_FLATTEN_FACTOR = 0.92f;
    private static final float DIRECTION_CHANGE_FACTOR = 0.1f;
    private static final float PREV_HORIZ_DIRECTION_CHANGE_WEIGHT = 0.75f;
    private static final float PREV_VERT_DIRECTION_CHANGE_WEIGHT = 0.9f;
    private static final float MAX_ADD_DIRECTION_CHANGE_HORIZ = 4.0f;
    private static final float MAX_ADD_DIRECTION_CHANGE_VERT = 2.0f;
    private static final int CARVE_STEP_RARITY = 4;
    private static final double CAVE_FLOOR_DEPTH = -0.7;
    private static final Predicate<IBlockState> isBlockReplaceable = state -> state.func_177230_c() == Blocks.field_150348_b || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150349_c;
    private final World world;

    public GenericCavePrimer(World world) {
        this.world = world;
    }

    @Override
    public void primeChunk(CubicPos pos, ChunkPrimeWriter writer) {
        CubicStructureUtil.primeStructure(this.world, writer, pos, this::generate, 8, 1);
    }

    protected void generate(Random rand, ChunkPrimeWriter writer, int cubeXOrigin, int cubeYOrigin, int cubeZOrigin, CubicPos generatedCubicPos) {
        if (rand.nextInt(14) != 0) {
            return;
        }
        int nodes = rand.nextInt(rand.nextInt(rand.nextInt(15) + 1) + 1);
        for (int node = 0; node < nodes; ++node) {
            double branchStartX = (cubeXOrigin << 4) + rand.nextInt(16);
            double branchStartY = (cubeYOrigin << 4) + rand.nextInt(16);
            double branchStartZ = (cubeZOrigin << 4) + rand.nextInt(16);
            int subBranches = 1;
            if (rand.nextInt(4) == 0) {
                this.generateLargeNode(writer, rand, rand.nextLong(), generatedCubicPos, branchStartX, branchStartY, branchStartZ);
                subBranches += rand.nextInt(4);
            }
            for (int branch = 0; branch < subBranches; ++branch) {
                float horizDirAngle = rand.nextFloat() * (float)Math.PI * 2.0f;
                float vertDirAngle = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float baseHorizSize = rand.nextFloat() * 2.0f + rand.nextFloat();
                if (rand.nextInt(10) == 0) {
                    baseHorizSize *= rand.nextFloat() * rand.nextFloat() * 3.0f + 1.0f;
                }
                int startWalkedDistance = 0;
                int maxWalkedDistance = 0;
                double vertCaveSizeMod = 1.0;
                this.generateNode(writer, rand.nextLong(), generatedCubicPos, branchStartX, branchStartY, branchStartZ, baseHorizSize, horizDirAngle, vertDirAngle, startWalkedDistance, maxWalkedDistance, vertCaveSizeMod);
            }
        }
    }

    private void generateLargeNode(ChunkPrimeWriter cube, Random rand, long seed, CubicPos generatedCubicPos, double x, double y, double z) {
        float baseHorizSize = 1.0f + rand.nextFloat() * 6.0f;
        float horizDirAngle = 0.0f;
        float vertDirAngle = 0.0f;
        int startWalkedDistance = -1;
        int maxWalkedDistance = -1;
        double vertCaveSizeMod = 0.5;
        this.generateNode(cube, seed, generatedCubicPos, x, y, z, baseHorizSize, horizDirAngle, vertDirAngle, startWalkedDistance, maxWalkedDistance, vertCaveSizeMod);
    }

    private void generateNode(ChunkPrimeWriter cube, long seed, CubicPos generatedCubicPos, double caveX, double caveY, double caveZ, float baseCaveSize, float horizDirAngle, float vertDirAngle, int startWalkedDistance, int maxWalkedDistance, double vertCaveSizeMod) {
        int walkedDistance;
        Random rand = new Random(seed);
        float horizDirChange = 0.0f;
        float vertDirChange = 0.0f;
        if (maxWalkedDistance <= 0) {
            int maxBlockRadius = 112;
            maxWalkedDistance = maxBlockRadius - rand.nextInt(maxBlockRadius / 4);
        }
        boolean finalStep = false;
        if (startWalkedDistance == -1) {
            walkedDistance = maxWalkedDistance / 2;
            finalStep = true;
        } else {
            walkedDistance = startWalkedDistance;
        }
        int splitPoint = rand.nextInt(maxWalkedDistance / 2) + maxWalkedDistance / 4;
        while (walkedDistance < maxWalkedDistance) {
            float fractionWalked = (float)walkedDistance / (float)maxWalkedDistance;
            double caveSizeHoriz = 1.5 + (double)(MathHelper.func_76126_a((float)(fractionWalked * (float)Math.PI)) * baseCaveSize);
            double caveSizeVert = caveSizeHoriz * vertCaveSizeMod;
            float xzDirectionFactor = MathHelper.func_76134_b((float)vertDirAngle);
            float yDirectionFactor = MathHelper.func_76126_a((float)vertDirAngle);
            caveX += (double)(MathHelper.func_76134_b((float)horizDirAngle) * xzDirectionFactor);
            caveY += (double)yDirectionFactor;
            caveZ += (double)(MathHelper.func_76126_a((float)horizDirAngle) * xzDirectionFactor);
            vertDirAngle = rand.nextInt(6) == 0 ? (vertDirAngle *= 0.92f) : (vertDirAngle *= 0.7f);
            vertDirAngle += vertDirChange * 0.1f;
            horizDirAngle += horizDirChange * 0.1f;
            vertDirChange *= 0.9f;
            horizDirChange *= 0.75f;
            vertDirChange += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 2.0f;
            horizDirChange += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f;
            if (!finalStep && walkedDistance == splitPoint && baseCaveSize > 1.0f) {
                this.generateNode(cube, rand.nextLong(), generatedCubicPos, caveX, caveY, caveZ, rand.nextFloat() * 0.5f + 0.5f, horizDirAngle - 1.5707964f, vertDirAngle / 3.0f, walkedDistance, maxWalkedDistance, 1.0);
                this.generateNode(cube, rand.nextLong(), generatedCubicPos, caveX, caveY, caveZ, rand.nextFloat() * 0.5f + 0.5f, horizDirAngle + 1.5707964f, vertDirAngle / 3.0f, walkedDistance, maxWalkedDistance, 1.0);
                return;
            }
            if (rand.nextInt(4) != 0 || finalStep) {
                double maxDistToCube;
                double maxStepsDist;
                double zDist;
                double yDist;
                double xDist = caveX - (double)generatedCubicPos.getCenterX();
                if (xDist * xDist + (yDist = caveY - (double)generatedCubicPos.getCenterY()) * yDist + (zDist = caveZ - (double)generatedCubicPos.getCenterZ()) * zDist - (maxStepsDist = (double)(maxWalkedDistance - walkedDistance)) * maxStepsDist > (maxDistToCube = (double)baseCaveSize * Math.max(1.0, vertCaveSizeMod) + 1.5 + 16.0) * maxDistToCube) {
                    return;
                }
                this.tryCarveBlocks(cube, generatedCubicPos, caveX, caveY, caveZ, caveSizeHoriz, caveSizeVert);
                if (finalStep) {
                    return;
                }
            }
            ++walkedDistance;
        }
    }

    private void tryCarveBlocks(@Nonnull ChunkPrimeWriter cube, @Nonnull CubicPos generatedCubicPos, double caveX, double caveY, double caveZ, double caveSizeHoriz, double caveSizeVert) {
        double genCubeCenterX = generatedCubicPos.getCenterX();
        double genCubeCenterY = generatedCubicPos.getCenterY();
        double genCubeCenterZ = generatedCubicPos.getCenterZ();
        if (caveX < genCubeCenterX - 16.0 - caveSizeHoriz * 2.0 || caveY < genCubeCenterY - 16.0 - caveSizeVert * 2.0 || caveZ < genCubeCenterZ - 16.0 - caveSizeHoriz * 2.0 || caveX > genCubeCenterX + 16.0 + caveSizeHoriz * 2.0 || caveY > genCubeCenterY + 16.0 + caveSizeVert * 2.0 || caveZ > genCubeCenterZ + 16.0 + caveSizeHoriz * 2.0) {
            return;
        }
        int minLocalX = MathHelper.func_76128_c((double)(caveX - caveSizeHoriz)) - generatedCubicPos.getMinX() - 1;
        int maxLocalX = MathHelper.func_76128_c((double)(caveX + caveSizeHoriz)) - generatedCubicPos.getMinX() + 1;
        int minLocalY = MathHelper.func_76128_c((double)(caveY - caveSizeVert)) - generatedCubicPos.getMinY() - 1;
        int maxLocalY = MathHelper.func_76128_c((double)(caveY + caveSizeVert)) - generatedCubicPos.getMinY() + 1;
        int minLocalZ = MathHelper.func_76128_c((double)(caveZ - caveSizeHoriz)) - generatedCubicPos.getMinZ() - 1;
        int maxLocalZ = MathHelper.func_76128_c((double)(caveZ + caveSizeHoriz)) - generatedCubicPos.getMinZ() + 1;
        if (maxLocalX <= 0 || minLocalX >= 16 || maxLocalY <= 0 || minLocalY >= 16 || maxLocalZ <= 0 || minLocalZ >= 16) {
            return;
        }
        StructureBoundingBox boundingBox = new StructureBoundingBox(minLocalX, minLocalY, minLocalZ, maxLocalX, maxLocalY, maxLocalZ);
        CubicStructureUtil.clampBoundingBoxToLocalCube(boundingBox);
        boolean hitLiquid = CubicStructureUtil.scanWallsForBlock(cube, boundingBox, b -> b.func_177230_c() == Blocks.field_150353_l || b.func_177230_c() == Blocks.field_150356_k);
        if (!hitLiquid) {
            this.carveBlocks(cube, generatedCubicPos, caveX, caveY, caveZ, caveSizeHoriz, caveSizeVert, boundingBox);
        }
    }

    private void carveBlocks(ChunkPrimeWriter cube, CubicPos generatedCubicPos, double caveX, double caveY, double caveZ, double caveSizeHoriz, double caveSizeVert, StructureBoundingBox boundingBox) {
        int generatedCubeX = generatedCubicPos.getX();
        int generatedCubeY = generatedCubicPos.getY();
        int generatedCubeZ = generatedCubicPos.getZ();
        int minX = boundingBox.field_78897_a;
        int maxX = boundingBox.field_78893_d;
        int minY = boundingBox.field_78895_b;
        int maxY = boundingBox.field_78894_e;
        int minZ = boundingBox.field_78896_c;
        int maxZ = boundingBox.field_78892_f;
        for (int localX = minX; localX < maxX; ++localX) {
            double distX = CubicStructureUtil.normalizedDistance(generatedCubeX, localX, caveX, caveSizeHoriz);
            for (int localZ = minZ; localZ < maxZ; ++localZ) {
                double distZ = CubicStructureUtil.normalizedDistance(generatedCubeZ, localZ, caveZ, caveSizeHoriz);
                if (distX * distX + distZ * distZ >= 1.0) continue;
                for (int localY = minY; localY < maxY; ++localY) {
                    double distYAbove;
                    double distY = CubicStructureUtil.normalizedDistance(generatedCubeY, localY, caveY, caveSizeVert);
                    IBlockState state = cube.get(localX, localY, localZ);
                    if (!isBlockReplaceable.test(state)) continue;
                    if (GenericCavePrimer.shouldCarveBlock(distX, distY, distZ)) {
                        cube.set(localX, localY, localZ, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    if (state.func_177230_c() != Blocks.field_150346_d || !GenericCavePrimer.shouldCarveBlock(distX, distYAbove = CubicStructureUtil.normalizedDistance(generatedCubeY, localY + 1, caveY, caveSizeVert), distZ)) continue;
                    cube.set(localX, localY, localZ, Blocks.field_150349_c.func_176223_P());
                }
            }
        }
    }

    private static boolean shouldCarveBlock(double distX, double distY, double distZ) {
        return distY > -0.7 && distX * distX + distY * distY + distZ * distZ < 1.0;
    }
}

