/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.gengen.util.primer;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.gegy1000.gengen.api.CubicPos;
import net.gegy1000.gengen.api.HeightFunction;
import net.gegy1000.gengen.api.generator.GenericChunkPrimer;
import net.gegy1000.gengen.api.writer.ChunkPrimeWriter;
import net.gegy1000.gengen.util.primer.CubicStructureUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GenericRavinePrimer
implements GenericChunkPrimer {
    private static final int RANGE = 8;
    private static final int RAVINE_RARITY = 100;
    private static final double LAVA_HEIGHT_OFFSET = -10.0;
    private static final double LAVA_HEIGHT_Y_FACTOR = -0.1;
    private static final double VERT_SIZE_FACTOR = 3.0;
    private static final double RAVINE_SIZE_ADD = 1.5;
    private static final double MIN_RAND_SIZE_FACTOR = 0.75;
    private static final double MAX_RAND_SIZE_FACTOR = 1.0;
    private static final double FLATTEN_FACTOR = 0.7;
    private static final double DIRECTION_CHANGE_FACTOR = 0.05;
    private static final double PREV_HORIZ_DIRECTION_CHANGE_WEIGHT = 0.5;
    private static final double PREV_VERT_DIRECTION_CHANGE_WEIGHT = 0.8;
    private static final double MAX_ADD_DIRECTION_CHANGE_HORIZ = 4.0;
    private static final double MAX_ADD_DIRECTION_CHANGE_VERT = 2.0;
    private static final int CARVE_STEP_RARITY = 4;
    private static final double STRETCH_Y_FACTOR = 6.0;
    @Nonnull
    private static final Predicate<IBlockState> isBlockReplaceable = state -> state.func_177230_c() == Blocks.field_150348_b || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150349_c;
    private final World world;
    private final HeightFunction surfaceFunction;
    @Nonnull
    private float[] widthDecreaseFactors = new float[1024];

    public GenericRavinePrimer(World world, HeightFunction surfaceFunction) {
        this.world = world;
        this.surfaceFunction = surfaceFunction;
    }

    @Override
    public void primeChunk(CubicPos pos, ChunkPrimeWriter writer) {
        CubicStructureUtil.primeStructure(this.world, writer, pos, this::generate, 8, 1);
    }

    protected void generate(Random rand, ChunkPrimeWriter writer, int structureX, int structureY, int structureZ, CubicPos generatedCubePos) {
        int surfaceY = this.surfaceFunction.apply((structureX << 4) + 8, (structureZ << 4) + 8);
        int surfaceCubeY = surfaceY >> 4;
        if (rand.nextInt(100) != 0 || structureY > surfaceCubeY) {
            return;
        }
        double startX = (structureX << 4) + rand.nextInt(16);
        double startY = (structureY << 4) + rand.nextInt(16);
        double startZ = (structureZ << 4) + rand.nextInt(16);
        float vertDirectionAngle = rand.nextFloat() * (float)Math.PI * 2.0f;
        float horizDirectionAngle = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
        float baseRavineSize = (rand.nextFloat() * 2.0f + rand.nextFloat()) * 2.0f;
        int startWalkedDistance = 0;
        int maxWalkedDistance = 0;
        int lavaHeight = (int)(startY - ((double)baseRavineSize + 1.5) * 3.0 + -10.0 + startY * -0.1);
        this.generateNode(writer, rand.nextLong(), generatedCubePos, startX, startY, startZ, baseRavineSize, vertDirectionAngle, horizDirectionAngle, startWalkedDistance, maxWalkedDistance, 3.0, lavaHeight);
    }

    private void generateNode(ChunkPrimeWriter writer, long seed, CubicPos generatedCubePos, double ravineX, double ravineY, double ravineZ, float baseRavineSize, float horizDirAngle, float vertDirAngle, int startWalkedDistance, int maxWalkedDistance, double vertRavineSizeMod, int lavaHeight) {
        int walkedDistance;
        Random rand = new Random(seed);
        float horizDirChange = 0.0f;
        float vertDirChange = 0.0f;
        if (maxWalkedDistance <= 0) {
            int maxBlockRadius = 112;
            maxWalkedDistance = maxBlockRadius - rand.nextInt(maxBlockRadius / 4);
        }
        boolean finalStep = false;
        if (startWalkedDistance == -1) {
            walkedDistance = maxWalkedDistance / 2;
            finalStep = true;
        } else {
            walkedDistance = startWalkedDistance;
        }
        this.widthDecreaseFactors = this.generateRavineWidthFactors(rand);
        while (walkedDistance < maxWalkedDistance) {
            float fractionWalked = (float)walkedDistance / (float)maxWalkedDistance;
            double ravineSizeHoriz = 1.5 + (double)(MathHelper.func_76126_a((float)(fractionWalked * (float)Math.PI)) * baseRavineSize);
            double ravineSizeVert = ravineSizeHoriz * vertRavineSizeMod;
            ravineSizeHoriz *= (double)rand.nextFloat() * 0.25 + 0.75;
            ravineSizeVert *= (double)rand.nextFloat() * 0.25 + 0.75;
            float xzDirectionFactor = MathHelper.func_76134_b((float)vertDirAngle);
            float yDirectionFactor = MathHelper.func_76126_a((float)vertDirAngle);
            ravineX += (double)(MathHelper.func_76134_b((float)horizDirAngle) * xzDirectionFactor);
            ravineY += (double)yDirectionFactor;
            ravineZ += (double)(MathHelper.func_76126_a((float)horizDirAngle) * xzDirectionFactor);
            vertDirAngle = (float)((double)vertDirAngle * 0.7);
            vertDirAngle = (float)((double)vertDirAngle + (double)vertDirChange * 0.05);
            horizDirAngle = (float)((double)horizDirAngle + (double)horizDirChange * 0.05);
            vertDirChange = (float)((double)vertDirChange * 0.8);
            horizDirChange = (float)((double)horizDirChange * 0.5);
            vertDirChange = (float)((double)vertDirChange + (double)((rand.nextFloat() - rand.nextFloat()) * rand.nextFloat()) * 2.0);
            horizDirChange = (float)((double)horizDirChange + (double)((rand.nextFloat() - rand.nextFloat()) * rand.nextFloat()) * 4.0);
            if (rand.nextInt(4) != 0 || finalStep) {
                double maxDistToCube;
                double maxStepsDist;
                double zDist;
                double xDist = ravineX - (double)generatedCubePos.getCenterX();
                if (xDist * xDist + (zDist = ravineZ - (double)generatedCubePos.getCenterZ()) * zDist - (maxStepsDist = (double)(maxWalkedDistance - walkedDistance)) * maxStepsDist > (maxDistToCube = (double)baseRavineSize + 1.5 + 16.0) * maxDistToCube) {
                    return;
                }
                this.tryCarveBlocks(writer, generatedCubePos, ravineX, ravineY, ravineZ, ravineSizeHoriz, ravineSizeVert, lavaHeight);
                if (finalStep) {
                    return;
                }
            }
            ++walkedDistance;
        }
    }

    private void tryCarveBlocks(ChunkPrimeWriter writer, CubicPos generatedCubePos, double ravineX, double ravineY, double ravineZ, double ravineSizeHoriz, double ravineSizeVert, int lavaHeight) {
        double genCubeCenterX = generatedCubePos.getCenterX();
        double genCubeCenterY = generatedCubePos.getCenterY();
        double genCubeCenterZ = generatedCubePos.getCenterZ();
        if (ravineX < genCubeCenterX - 16.0 - ravineSizeHoriz * 2.0 || ravineY < genCubeCenterY - 16.0 - ravineSizeVert * 2.0 || ravineZ < genCubeCenterZ - 16.0 - ravineSizeHoriz * 2.0 || ravineX > genCubeCenterX + 16.0 + ravineSizeHoriz * 2.0 || ravineY > genCubeCenterY + 16.0 + ravineSizeVert * 2.0 || ravineZ > genCubeCenterZ + 16.0 + ravineSizeHoriz * 2.0) {
            return;
        }
        int minLocalX = MathHelper.func_76128_c((double)(ravineX - ravineSizeHoriz)) - generatedCubePos.getMinX() - 1;
        int maxLocalX = MathHelper.func_76128_c((double)(ravineX + ravineSizeHoriz)) - generatedCubePos.getMinX() + 1;
        int minLocalY = MathHelper.func_76128_c((double)(ravineY - ravineSizeVert)) - generatedCubePos.getMinY() - 1;
        int maxLocalY = MathHelper.func_76128_c((double)(ravineY + ravineSizeVert)) - generatedCubePos.getMinY() + 1;
        int minLocalZ = MathHelper.func_76128_c((double)(ravineZ - ravineSizeHoriz)) - generatedCubePos.getMinZ() - 1;
        int maxLocalZ = MathHelper.func_76128_c((double)(ravineZ + ravineSizeHoriz)) - generatedCubePos.getMinZ() + 1;
        if (maxLocalX <= 0 || minLocalX >= 16 || maxLocalY <= 0 || minLocalY >= 16 || maxLocalZ <= 0 || minLocalZ >= 16) {
            return;
        }
        StructureBoundingBox boundingBox = new StructureBoundingBox(minLocalX, minLocalY, minLocalZ, maxLocalX, maxLocalY, maxLocalZ);
        CubicStructureUtil.clampBoundingBoxToLocalCube(boundingBox);
        boolean hitLiquid = CubicStructureUtil.scanWallsForBlock(writer, boundingBox, b -> b.func_177230_c() == Blocks.field_150355_j || b.func_177230_c() == Blocks.field_150358_i);
        if (!hitLiquid) {
            this.carveBlocks(writer, generatedCubePos, ravineX, ravineY, ravineZ, ravineSizeHoriz, ravineSizeVert, boundingBox, lavaHeight);
        }
    }

    private void carveBlocks(ChunkPrimeWriter writer, CubicPos generatedCubePos, double ravineX, double ravineY, double ravineZ, double ravineSizeHoriz, double ravineSizeVert, StructureBoundingBox boundingBox, int lavaHeight) {
        int generatedCubeX = generatedCubePos.getX();
        int generatedCubeY = generatedCubePos.getY();
        int generatedCubeZ = generatedCubePos.getZ();
        int minX = boundingBox.field_78897_a;
        int maxX = boundingBox.field_78893_d;
        int minY = boundingBox.field_78895_b;
        int maxY = boundingBox.field_78894_e;
        int minZ = boundingBox.field_78896_c;
        int maxZ = boundingBox.field_78892_f;
        for (int localX = minX; localX < maxX; ++localX) {
            double distX = CubicStructureUtil.normalizedDistance(generatedCubeX, localX, ravineX, ravineSizeHoriz);
            for (int localZ = minZ; localZ < maxZ; ++localZ) {
                double distZ = CubicStructureUtil.normalizedDistance(generatedCubeZ, localZ, ravineZ, ravineSizeHoriz);
                if (distX * distX + distZ * distZ >= 1.0) continue;
                for (int localY = minY; localY < maxY; ++localY) {
                    double widthDecreaseFactor = this.widthDecreaseFactors[localY + generatedCubeY * 16 & 0xFF];
                    double distY = CubicStructureUtil.normalizedDistance(generatedCubeY, localY, ravineY, ravineSizeVert);
                    if ((distX * distX + distZ * distZ) * widthDecreaseFactor + distY * distY / 6.0 >= 1.0 || !isBlockReplaceable.test(writer.get(localX, localY, localZ))) continue;
                    int globalY = (generatedCubeY << 4) + localY;
                    if (globalY < lavaHeight) {
                        writer.set(localX, localY, localZ, Blocks.field_150356_k.func_176223_P());
                        continue;
                    }
                    writer.set(localX, localY, localZ, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private float[] generateRavineWidthFactors(Random rand) {
        float[] values = new float[1024];
        float value = 1.0f;
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || rand.nextInt(3) == 0) {
                value = 1.0f + rand.nextFloat() * rand.nextFloat();
            }
            values[i] = value * value;
        }
        return values;
    }
}

