/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.justnow.executor;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import net.gegy1000.justnow.executor.Task;

public final class TaskQueue {
    private final LinkedBlockingDeque<Task<?>> tasks = new LinkedBlockingDeque();

    public void clear() {
        this.tasks.clear();
    }

    public void enqueue(Task<?> task) {
        if (task.isInvalid()) {
            return;
        }
        this.tasks.add(task);
    }

    public boolean remove(Task<?> task) {
        return this.tasks.remove(task);
    }

    public Task<?> take() throws InterruptedException {
        return this.tasks.take();
    }

    public void drainTo(Collection<Task<?>> target) {
        while (!this.tasks.isEmpty()) {
            target.add(this.tasks.remove());
        }
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public Waker waker(Task task) {
        return new Waker(task);
    }

    public class Waker
    implements net.gegy1000.justnow.Waker {
        static final int READY = 0;
        static final int POLLING = 1;
        static final int AWOKEN = 2;
        private final Task<?> task;
        final AtomicInteger state = new AtomicInteger(2);

        private Waker(Task<?> task) {
            this.task = task;
        }

        @Override
        public void wake() {
            if (this.state.compareAndSet(1, 2)) {
                return;
            }
            if (this.state.compareAndSet(0, 2)) {
                TaskQueue.this.enqueue(this.task);
            }
        }

        void polling() {
            this.state.set(1);
        }

        void ready() {
            if (!this.state.compareAndSet(1, 0)) {
                TaskQueue.this.enqueue(this.task);
            }
        }
    }
}

