/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public class CopyBoxWidget
extends Gui {
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("terrarium", "textures/gui/widgets.png");
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final int CLIPBOARD_PADDING = 2;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final FontRenderer fontRenderer;
    private final String text;
    private boolean copied;

    public CopyBoxWidget(int x, int y, int width, int height, String text, FontRenderer fontRenderer) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
        this.fontRenderer = fontRenderer;
    }

    public void draw(int mouseX, int mouseY) {
        boolean selected;
        boolean bl = selected = mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.width && mouseY <= this.y + this.height;
        if (!selected) {
            this.copied = false;
        }
        CopyBoxWidget.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)(this.copied ? -12804036 : -6250336));
        CopyBoxWidget.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
        int clipboardSize = Math.min(this.width, this.height) - 4;
        String text = this.fontRenderer.func_78269_a(this.text, this.width - 8 - clipboardSize);
        int textX = this.x + 4;
        int textY = this.y + (this.height - 8) / 2;
        this.fontRenderer.func_175063_a(text, (float)textX, (float)textY, 0xFFFFFF);
        int minClipboardX = this.x + this.width - clipboardSize - 2;
        int minClipboardY = this.y + 2;
        int maxClipboardX = this.x + this.width - 2;
        int maxClipboardY = this.y + this.height - 2;
        if (mouseX >= minClipboardX && mouseY >= minClipboardY && mouseX <= maxClipboardX && mouseY <= maxClipboardY) {
            CopyBoxWidget.func_73734_a((int)minClipboardX, (int)minClipboardY, (int)maxClipboardX, (int)maxClipboardY, (int)-8421505);
        } else {
            CopyBoxWidget.func_73734_a((int)minClipboardX, (int)minClipboardY, (int)maxClipboardX, (int)maxClipboardY, (int)-6250336);
        }
        MC.func_110434_K().func_110577_a(WIDGETS_TEXTURE);
        this.func_73729_b(minClipboardX, minClipboardY, 64, 0, clipboardSize, clipboardSize);
        if (this.copied) {
            ScaledResolution resolution = new ScaledResolution(MC);
            ArrayList lines = Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.copy_box.copied.name", (Object[])new Object[0])});
            int screenWidth = resolution.func_78326_a();
            int screenHeight = resolution.func_78328_b();
            GuiUtils.drawHoveringText((List)lines, (int)((minClipboardX + maxClipboardX) / 2), (int)((minClipboardY + maxClipboardY) / 2), (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)this.fontRenderer);
            GlStateManager.func_179140_f();
            GlStateManager.func_179098_w();
        }
    }

    public void mouseClicked(int mouseX, int mouseY) {
        int clipboardWidth = Math.min(this.width, this.height) - 4;
        int minClipboardX = this.x + this.width - clipboardWidth - 2;
        int minClipboardY = this.y + 2;
        int maxClipboardX = this.x + this.width - 2;
        int maxClipboardY = this.y + this.height - 2;
        if (mouseX >= minClipboardX && mouseY >= minClipboardY && mouseX <= maxClipboardX && mouseY <= maxClipboardY) {
            GuiScreen.func_146275_d((String)this.text);
            this.copied = true;
        }
    }
}

