/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.util;

import java.util.Random;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.minecraft.util.math.MathHelper;

public final class Voronoi {
    private static final int FUZZ_SIZE = 64;
    private static final int FUZZ_MASK = 63;
    private final float[] fuzzTable;

    public Voronoi(float fuzzRadius, long seed) {
        Random random = new Random(seed);
        this.fuzzTable = Voronoi.makeFuzzTable(random, fuzzRadius);
    }

    private static float[] makeFuzzTable(Random random, float radius) {
        float[] table = new float[8192];
        for (int y = 0; y < 64; ++y) {
            for (int x = 0; x < 64; ++x) {
                float fx = Voronoi.fuzz(random, radius);
                float fy = Voronoi.fuzz(random, radius);
                int idx = (x + y * 64) * 2;
                table[idx] = fx;
                table[idx + 1] = fy;
            }
        }
        return table;
    }

    private static float fuzz(Random random, float fuzzRange) {
        float offset = 2.0f * random.nextFloat() - 1.0f;
        return 0.5f + offset * fuzzRange;
    }

    public void scaleBytes(byte[] src, byte[] dst, DataView srcView, DataView dstView, float scaleX, float scaleY, float offsetX, float offsetY) {
        int dstWidth = dstView.getWidth();
        int dstHeight = dstView.getHeight();
        int srcWidth = srcView.getWidth();
        int srcHeight = srcView.getHeight();
        if (dstWidth <= srcWidth && dstHeight <= srcHeight) {
            for (int dstY = 0; dstY < dstHeight; ++dstY) {
                int srcY = MathHelper.func_76141_d((float)((float)dstY * scaleY + offsetY));
                for (int dstX = 0; dstX < dstWidth; ++dstX) {
                    int srcX = MathHelper.func_76141_d((float)((float)dstX * scaleX + offsetX));
                    dst[dstX + dstY * dstWidth] = src[srcX + srcY * srcWidth];
                }
            }
            return;
        }
        for (int y = 0; y < dstHeight; ++y) {
            float srcY = (float)y * scaleY + offsetY;
            for (int x = 0; x < dstWidth; ++x) {
                float srcX = (float)x * scaleX + offsetX;
                int srcIndex = this.getCellIndex(srcView, srcX, srcY);
                int dstIndex = x + y * dstWidth;
                dst[dstIndex] = src[srcIndex];
            }
        }
    }

    private int getCellIndex(DataView srcView, float x, float y) {
        int originX = MathHelper.func_76141_d((float)x);
        int originY = MathHelper.func_76141_d((float)y);
        int offsetX = srcView.getX();
        int offsetY = srcView.getY();
        int minX = Math.max(originX - 1, 0);
        int minY = Math.max(originY - 1, 0);
        int maxX = Math.min(originX + 1, srcView.getWidth() - 1);
        int maxY = Math.min(originY + 1, srcView.getHeight() - 1);
        int cellIndex = 0;
        float selectionDistance = Float.MAX_VALUE;
        for (int srcY = minY; srcY <= maxY; ++srcY) {
            for (int srcX = minX; srcX <= maxX; ++srcX) {
                int tx = srcX + offsetX & 0x3F;
                int ty = srcY + offsetY & 0x3F;
                int ti = tx + ty * 64;
                float fuzzX = this.fuzzTable[ti];
                float deltaX = x - ((float)srcX + fuzzX);
                float fuzzY = this.fuzzTable[ti + 1];
                float deltaY = y - ((float)srcY + fuzzY);
                float distance = deltaX * deltaX + deltaY * deltaY;
                if (!(distance < selectionDistance)) continue;
                selectionDistance = distance;
                cellIndex = srcX + srcY * srcView.getWidth();
            }
        }
        return cellIndex;
    }
}

