/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.chunk;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.gegy1000.gengen.api.CubicPos;
import net.gegy1000.gengen.api.generator.GenericChunkGenerator;
import net.gegy1000.gengen.api.writer.ChunkPopulationWriter;
import net.gegy1000.gengen.api.writer.ChunkPrimeWriter;
import net.gegy1000.terrarium.server.capability.TerrariumCapabilities;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.util.Lazy;
import net.gegy1000.terrarium.server.world.composer.structure.StructureComposer;
import net.gegy1000.terrarium.server.world.data.ColumnData;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.ColumnDataEntry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ComposableChunkGenerator
implements GenericChunkGenerator {
    protected final World world;
    protected final Lazy<Optional<TerrariumWorld>> terrarium;

    public ComposableChunkGenerator(World world) {
        this.world = world;
        this.terrarium = Lazy.ofCapability(world, TerrariumCapabilities.world());
    }

    @Override
    public void primeChunk(CubicPos pos, ChunkPrimeWriter writer) {
        this.terrarium.get().ifPresent(terrarium -> {
            try (ColumnDataEntry.Handle handle = terrarium.getDataCache().acquireEntry(pos.getX(), pos.getZ());){
                ColumnData data = handle.join();
                terrarium.getSurfaceComposer().composeSurface((TerrariumWorld)terrarium, data, pos, writer);
                terrarium.getStructureComposer().primeStructures((TerrariumWorld)terrarium, pos, writer);
            }
        });
    }

    @Override
    public void populateChunk(CubicPos pos, ChunkPopulationWriter writer) {
        this.terrarium.get().ifPresent(terrarium -> {
            ColumnDataCache dataCache = terrarium.getDataCache();
            ColumnDataEntry.Handle[] handles = this.acquirePopulationHandles(pos, dataCache);
            terrarium.getStructureComposer().populateStructures((TerrariumWorld)terrarium, pos, writer);
            terrarium.getDecorationComposer().composeDecoration((TerrariumWorld)terrarium, pos, writer);
            for (ColumnDataEntry.Handle handle : handles) {
                handle.release();
            }
        });
    }

    protected ColumnDataEntry.Handle[] acquirePopulationHandles(CubicPos pos, ColumnDataCache dataCache) {
        return new ColumnDataEntry.Handle[]{dataCache.acquireEntry(pos.getX(), pos.getZ()), dataCache.acquireEntry(pos.getX() + 1, pos.getZ()), dataCache.acquireEntry(pos.getX(), pos.getZ() + 1), dataCache.acquireEntry(pos.getX() + 1, pos.getZ() + 1)};
    }

    @Override
    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType type, BlockPos pos) {
        return this.terrarium.get().map(terrarium -> terrarium.getStructureComposer().getPossibleCreatures((TerrariumWorld)terrarium, this.world, type, pos)).orElseGet(() -> this.world.func_180494_b(pos).func_76747_a(type));
    }

    @Override
    public void prepareStructures(CubicPos pos) {
        this.terrarium.get().ifPresent(terrarium -> terrarium.getStructureComposer().prepareStructures((TerrariumWorld)terrarium, pos));
    }

    @Override
    @Nullable
    public BlockPos getClosestStructure(String name, BlockPos pos, boolean findUnexplored) {
        return this.terrarium.get().map(terrarium -> {
            StructureComposer composer = terrarium.getStructureComposer();
            return composer.getClosestStructure((TerrariumWorld)terrarium, this.world, name, pos, findUnexplored);
        }).orElse(null);
    }

    @Override
    public boolean isInsideStructure(String name, BlockPos pos) {
        Optional<TerrariumWorld> terrariumOption = this.terrarium.get();
        if (terrariumOption.isPresent()) {
            TerrariumWorld terrarium = terrariumOption.get();
            StructureComposer composer = terrarium.getStructureComposer();
            return composer.isInsideStructure(terrarium, this.world, name, pos);
        }
        return false;
    }
}

