/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.chunk.tracker;

import io.github.opencubicchunks.cubicchunks.api.util.CubePos;
import io.github.opencubicchunks.cubicchunks.api.world.CubeUnWatchEvent;
import io.github.opencubicchunks.cubicchunks.api.world.CubeWatchEvent;
import io.github.opencubicchunks.cubicchunks.api.world.ICube;
import io.github.opencubicchunks.cubicchunks.core.server.CubeProviderServer;
import io.github.opencubicchunks.cubicchunks.core.server.CubeWatcher;
import io.github.opencubicchunks.cubicchunks.core.server.PlayerCubeMap;
import io.github.opencubicchunks.cubicchunks.core.server.chunkio.ICubeIO;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import net.gegy1000.terrarium.Terrarium;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class SavedCubeTracker {
    private static Field cubeWatcherPlayersField;
    private static final EnumMap<DimensionType, WorldTracker> TRACKERS;

    public static boolean isSaved(World world, CubePos cubePos) {
        WorldTracker tracker = TRACKERS.get(world.field_73011_w.func_186058_p());
        if (tracker != null) {
            return tracker.isSaved(cubePos);
        }
        return false;
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        TRACKERS.put(event.getWorld().field_73011_w.func_186058_p(), new WorldTracker());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        TRACKERS.remove(event.getWorld().field_73011_w.func_186058_p());
    }

    @SubscribeEvent
    public static void onCubeWatch(CubeWatchEvent event) {
        ICube cube = event.getCube();
        if (cube == null) {
            return;
        }
        World world = cube.getWorld();
        WorldTracker tracker = TRACKERS.get(world.field_73011_w.func_186058_p());
        if (tracker != null) {
            CubePos coords = cube.getCoords();
            boolean saved = SavedCubeTracker.isCubeSaved(world, coords);
            tracker.mark(coords, saved);
        }
    }

    @SubscribeEvent
    public static void onCubeUnwatch(CubeUnWatchEvent event) {
        WorldTracker tracker;
        CubePos coords;
        ICube cube = event.getCube();
        if (cube == null) {
            return;
        }
        World world = cube.getWorld();
        if (!SavedCubeTracker.isCubeTracked(world, coords = cube.getCoords()) && (tracker = TRACKERS.get(world.field_73011_w.func_186058_p())) != null) {
            tracker.remove(coords);
        }
    }

    private static boolean isCubeTracked(World world, CubePos pos) {
        PlayerChunkMap chunkMap;
        if (world instanceof WorldServer && (chunkMap = ((WorldServer)world).func_184164_w()) instanceof PlayerCubeMap) {
            PlayerCubeMap cubeMap = (PlayerCubeMap)chunkMap;
            Collection<EntityPlayerMP> watchingPlayers = SavedCubeTracker.getWatchingPlayers(cubeMap, pos);
            return !watchingPlayers.isEmpty();
        }
        return false;
    }

    private static Collection<EntityPlayerMP> getWatchingPlayers(PlayerCubeMap cubeMap, CubePos pos) {
        CubeWatcher cubeWatcher;
        if (cubeWatcherPlayersField != null && (cubeWatcher = cubeMap.getCubeWatcher(pos)) != null) {
            try {
                return (List)cubeWatcherPlayersField.get(cubeWatcher);
            }
            catch (IllegalAccessException e) {
                Terrarium.LOGGER.warn("Failed to get cube watching players", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private static boolean isCubeSaved(World world, CubePos pos) {
        ChunkProviderServer provider;
        if (world instanceof WorldServer && (provider = ((WorldServer)world).func_72863_F()) instanceof CubeProviderServer) {
            ICubeIO io = ((CubeProviderServer)provider).getCubeIO();
            return io.cubeExists(pos.getX(), pos.getY(), pos.getZ());
        }
        return false;
    }

    static {
        try {
            cubeWatcherPlayersField = CubeWatcher.class.getDeclaredField("players");
            cubeWatcherPlayersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Terrarium.LOGGER.error("Failed to find cube watcher players field", (Throwable)e);
        }
        TRACKERS = new EnumMap(DimensionType.class);
    }

    private static class WorldTracker {
        private final Object2BooleanMap<CubePos> savedStates = new Object2BooleanOpenHashMap();

        private WorldTracker() {
        }

        boolean isSaved(CubePos pos) {
            return this.savedStates.getBoolean((Object)pos);
        }

        void mark(CubePos pos, boolean saved) {
            this.savedStates.put((Object)pos, saved);
        }

        void remove(CubePos pos) {
            this.savedStates.removeBoolean((Object)pos);
        }
    }
}

