/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataStore;
import net.gegy1000.terrarium.server.world.data.DataView;

public final class ColumnData {
    private final DataView view;
    private final DataStore<Optional<?>> store;

    ColumnData(DataView view, DataStore<Optional<?>> store) {
        this.view = view;
        this.store = store;
    }

    @Nonnull
    public DataView getView() {
        return this.view;
    }

    public boolean contains(DataKey<?> key) {
        Optional<?> optional = this.store.get(key);
        return optional != null && optional.isPresent();
    }

    public <T> Optional<T> get(DataKey<T> key) {
        Optional<?> data = this.store.get(key);
        if (data == null) {
            return Optional.empty();
        }
        return data;
    }

    public <T> T getOrDefault(DataKey<T> key) {
        return (T)this.get(key).orElseGet(() -> key.createDefault(this.view));
    }

    public Optional<With> with(DataKey<?> ... keys) {
        for (DataKey<?> key : keys) {
            Optional<?> value = this.store.get(key);
            if (value != null && value.isPresent()) continue;
            return Optional.empty();
        }
        return Optional.of(new With(Sets.newHashSet((Object[])keys)));
    }

    public final class With {
        private final Set<DataKey<?>> keys;

        private With(Set<DataKey<?>> keys) {
            this.keys = keys;
        }

        public <T> T get(DataKey<T> key) {
            if (!this.keys.contains(key)) {
                throw new IllegalArgumentException();
            }
            return ColumnData.this.get(key).orElseThrow(IllegalStateException::new);
        }
    }
}

